/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.message;

import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthi;
import com.bobmowzie.mowziesmobs.server.inventory.ContainerUmvuthiTrade;
import com.bobmowzie.mowziesmobs.server.potion.EffectHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class MessageUmvuthiTrade {
    private int entityID;

    public MessageUmvuthiTrade() {
    }

    public MessageUmvuthiTrade(LivingEntity sender) {
        this.entityID = sender.m_19879_();
    }

    public static void serialize(MessageUmvuthiTrade message, FriendlyByteBuf buf) {
        buf.m_130130_(message.entityID);
    }

    public static MessageUmvuthiTrade deserialize(FriendlyByteBuf buf) {
        MessageUmvuthiTrade message = new MessageUmvuthiTrade();
        message.entityID = buf.m_130242_();
        return message;
    }

    public static class Handler
    implements BiConsumer<MessageUmvuthiTrade, Supplier<NetworkEvent.Context>> {
        @Override
        public void accept(MessageUmvuthiTrade message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            ServerPlayer player = context.getSender();
            context.enqueueWork(() -> {
                if (player != null) {
                    Entity entity = player.m_9236_().m_6815_(message.entityID);
                    if (!(entity instanceof EntityUmvuthi)) {
                        return;
                    }
                    EntityUmvuthi umvuthi = (EntityUmvuthi)entity;
                    if (umvuthi.getCustomer() != player) {
                        return;
                    }
                    AbstractContainerMenu container = player.f_36096_;
                    if (!(container instanceof ContainerUmvuthiTrade)) {
                        return;
                    }
                    boolean satisfied = umvuthi.hasTradedWith((Player)player);
                    if (!satisfied && (satisfied = umvuthi.fulfillDesire(container.m_38853_(0)))) {
                        umvuthi.rememberTrade((Player)player);
                        ((ContainerUmvuthiTrade)container).returnItems();
                        container.m_38946_();
                    }
                    if (satisfied) {
                        player.m_7292_(new MobEffectInstance((MobEffect)EffectHandler.SUNS_BLESSING.get(), -1, 0, false, false));
                        if (umvuthi.getActiveAbilityType() != EntityUmvuthi.BLESS_ABILITY) {
                            umvuthi.sendAbilityMessage(EntityUmvuthi.BLESS_ABILITY);
                            umvuthi.m_5496_((SoundEvent)MMSounds.ENTITY_UMVUTHI_BLESS.get(), 2.0f, 1.0f);
                        }
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }
}

