/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity;

import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.BodyRotationControl;

public class SmartBodyHelper
extends BodyRotationControl {
    private static final float MAX_ROTATE = 75.0f;
    private static final int HISTORY_SIZE = 10;
    private final Mob entity;
    private int rotateTime;
    private float targetYawHead;
    private final double[] histPosX = new double[10];
    private final double[] histPosZ = new double[10];

    public SmartBodyHelper(Mob entity) {
        super(entity);
        this.entity = entity;
    }

    public void m_8121_() {
        double dz;
        for (int i = this.histPosX.length - 1; i > 0; --i) {
            this.histPosX[i] = this.histPosX[i - 1];
            this.histPosZ[i] = this.histPosZ[i - 1];
        }
        this.histPosX[0] = this.entity.m_20185_();
        this.histPosZ[0] = this.entity.m_20189_();
        double dx = this.delta(this.histPosX);
        double distSq = dx * dx + (dz = this.delta(this.histPosZ)) * dz;
        if (distSq > 2.5E-7) {
            boolean isStrafing = false;
            if (this.entity instanceof MowzieEntity) {
                isStrafing = ((MowzieEntity)this.entity).isStrafing();
            }
            if (!isStrafing) {
                double moveAngle = (float)Mth.m_14136_((double)dz, (double)dx) * 57.295776f - 90.0f;
                this.entity.f_20883_ = (float)((double)this.entity.f_20883_ + Mth.m_14175_((double)(moveAngle - (double)this.entity.f_20883_)) * (double)0.6f);
                this.targetYawHead = this.entity.f_20885_;
                this.rotateTime = 0;
            } else {
                super.m_8121_();
            }
        } else if (this.entity.m_20197_().isEmpty() || !(this.entity.m_20197_().get(0) instanceof Mob)) {
            float limit = 75.0f;
            if (Math.abs(this.entity.f_20885_ - this.targetYawHead) > 15.0f) {
                this.rotateTime = 0;
                this.targetYawHead = this.entity.f_20885_;
            } else {
                ++this.rotateTime;
                int speed = 10;
                if (this.rotateTime > 10) {
                    limit = Math.max(1.0f - (float)(this.rotateTime - 10) / 10.0f, 0.0f) * 75.0f;
                }
            }
            this.entity.f_20883_ = SmartBodyHelper.approach(this.entity.f_20885_, this.entity.f_20883_, limit);
        }
    }

    private double delta(double[] arr) {
        return this.mean(arr, 0) - this.mean(arr, 5);
    }

    private double mean(double[] arr, int start) {
        double mean = 0.0;
        for (int i = 0; i < 5; ++i) {
            mean += arr[i + start];
        }
        return mean / (double)arr.length;
    }

    public static float approach(float target, float current, float limit) {
        float delta = Mth.m_14177_((float)(current - target));
        if (delta < -limit) {
            delta = -limit;
        } else if (delta >= limit) {
            delta = limit;
        }
        return target + delta * 0.55f;
    }
}

