/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.UUID;
import mod.azure.azurelib.animation.impl.AzItemAnimator;
import mod.azure.azurelib.model.AzBakedModel;
import mod.azure.azurelib.render.AzProvider;
import mod.azure.azurelib.render.AzRendererPipelineContext;
import mod.azure.azurelib.render.item.AzItemGuiRenderUtil;
import mod.azure.azurelib.render.item.AzItemRendererConfig;
import mod.azure.azurelib.render.item.AzItemRendererPipeline;
import mod.azure.azurelib.render.item.AzItemRendererPipelineContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AzItemRenderer {
    private final AzItemRendererConfig config;
    private final AzProvider<UUID, ItemStack> provider;
    public final AzItemRendererPipeline rendererPipeline;
    @Nullable
    private AzItemAnimator reusedAzItemAnimator;

    protected AzItemRenderer(AzItemRendererConfig config) {
        this.rendererPipeline = this.createPipeline(config);
        this.provider = new AzProvider<UUID, ItemStack>(config::createAnimator, config::modelLocation, animator -> {
            if (animator.m_41783_() != null && animator.m_41783_().m_128441_("az_id")) {
                animator.m_41783_().m_128342_("az_id");
            }
            return UUID.randomUUID();
        });
        this.config = config;
    }

    protected AzItemRendererPipeline createPipeline(AzItemRendererConfig config) {
        return new AzItemRendererPipeline(config, this);
    }

    public void renderByGui(ItemStack stack, ItemDisplayContext transformType, @NotNull PoseStack poseStack, @NotNull MultiBufferSource source, int packedLight) {
        AzRendererPipelineContext context = this.rendererPipeline.context();
        AzBakedModel model = this.provider.provideBakedModel(context.currentEntity(), stack);
        AzItemRendererPipelineContext itemContext = (AzItemRendererPipelineContext)context;
        itemContext.setTransformType(transformType);
        this.prepareAnimator(stack, model);
        AzItemGuiRenderUtil.renderInGui(this.config, this.rendererPipeline, stack, model, stack, poseStack, source, packedLight);
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transformType, @NotNull PoseStack poseStack, @NotNull MultiBufferSource source, int packedLight) {
        AzRendererPipelineContext context = this.rendererPipeline.context();
        AzBakedModel model = this.provider.provideBakedModel(null, stack);
        float partialTick = Minecraft.m_91087_().m_91296_();
        ResourceLocation textureLocation = this.config.textureLocation(context.currentEntity(), stack);
        RenderType renderType = this.rendererPipeline.context().getDefaultRenderType(stack, textureLocation, source, partialTick, this.config.getRenderType(context.currentEntity(), stack), this.config.alpha(stack));
        boolean withGlint = stack != null && stack.m_41790_();
        VertexConsumer buffer = ItemRenderer.m_115222_((MultiBufferSource)source, (RenderType)renderType, (boolean)false, (boolean)withGlint);
        AzItemRendererPipelineContext itemContext = (AzItemRendererPipelineContext)context;
        itemContext.setTransformType(transformType);
        this.prepareAnimator(stack, model);
        this.rendererPipeline.render(poseStack, model, stack, source, renderType, buffer, 0.0f, partialTick, packedLight);
    }

    private void prepareAnimator(ItemStack stack, AzBakedModel model) {
        this.reusedAzItemAnimator = (AzItemAnimator)this.provider.provideAnimator(this.rendererPipeline.context().currentEntity(), stack);
    }

    @Nullable
    public AzItemAnimator getAnimator() {
        return this.reusedAzItemAnimator;
    }

    public AzItemRendererConfig config() {
        return this.config;
    }
}

