/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import mod.azure.azurelib.cache.texture.AnimatableTexture;
import mod.azure.azurelib.render.AzLayerRenderer;
import mod.azure.azurelib.render.AzModelRenderer;
import mod.azure.azurelib.render.AzRendererConfig;
import mod.azure.azurelib.render.AzRendererPipeline;
import mod.azure.azurelib.render.AzRendererPipelineContext;
import mod.azure.azurelib.render.block.AzBlockEntityRenderer;
import mod.azure.azurelib.render.block.AzBlockEntityRendererConfig;
import mod.azure.azurelib.render.block.AzBlockEntityRendererPipelineContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class AzBlockEntityRendererPipeline<T extends BlockEntity>
extends AzRendererPipeline<Long, T> {
    private final AzBlockEntityRenderer<T> blockEntityRenderer;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public AzBlockEntityRendererPipeline(AzBlockEntityRendererConfig<T> config, AzBlockEntityRenderer<T> blockEntityRenderer) {
        super(config);
        this.blockEntityRenderer = blockEntityRenderer;
    }

    protected AzBlockEntityRendererPipelineContext<T> createContext(AzRendererPipeline<Long, T> rendererPipeline) {
        return (AzBlockEntityRendererPipelineContext)this.config.pipelineContext(this);
    }

    @Override
    protected AzModelRenderer<Long, T> createModelRenderer(AzLayerRenderer<Long, T> layerRenderer) {
        return this.config.modelRendererProvider(this, layerRenderer);
    }

    @Override
    protected AzLayerRenderer<Long, T> createLayerRenderer(AzRendererConfig<Long, T> config) {
        return new AzLayerRenderer(config::renderLayers);
    }

    @Override
    public void updateAnimatedTextureFrame(T entity) {
        AnimatableTexture.setAndUpdate(this.config.textureLocation(this.context().currentEntity(), entity));
    }

    @Override
    public void preRender(AzRendererPipelineContext<Long, T> context, boolean isReRender) {
        PoseStack poseStack = context.poseStack();
        this.entityRenderTranslations.set((Matrix4fc)poseStack.m_85850_().m_252922_());
        float scaleWidth = this.config.scaleWidth((BlockEntity)context.animatable());
        float scaleHeight = this.config.scaleHeight((BlockEntity)context.animatable());
        this.scaleModelForRender(context, scaleWidth, scaleHeight, isReRender);
        if (this.config.alpha((BlockEntity)context.animatable()) < 1.0f) {
            context.setAlpha(this.config.alpha((BlockEntity)context.animatable()));
        }
        this.config.preRenderEntry(context);
    }

    @Override
    public void postRender(AzRendererPipelineContext<Long, T> context, boolean isReRender) {
        this.config.postRenderEntry(context);
    }

    public AzBlockEntityRenderer<T> getRenderer() {
        return this.blockEntityRenderer;
    }
}

