/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.config.client.widget;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mod.azure.azurelib.config.client.WidgetAdder;
import mod.azure.azurelib.config.client.widget.ContainerWidget;
import mod.azure.azurelib.config.validate.NotificationSeverity;
import mod.azure.azurelib.config.validate.ValidationResult;
import mod.azure.azurelib.config.value.ConfigValue;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;

public class ConfigEntryWidget
extends ContainerWidget
implements WidgetAdder {
    public static final Component EDIT = Component.m_237115_((String)"text.azurelib.value.edit");
    public static final Component BACK = Component.m_237115_((String)"text.azurelib.value.back");
    public static final Component REVERT_DEFAULTS = Component.m_237115_((String)"text.azurelib.value.revert.default");
    public static final Component REVERT_DEFAULTS_DIALOG_TEXT = Component.m_237115_((String)"text.azurelib.value.revert.default.dialog");
    public static final Component REVERT_CHANGES = Component.m_237115_((String)"text.azurelib.value.revert.changes");
    public static final Component REVERT_CHANGES_DIALOG_TEXT = Component.m_237115_((String)"text.azurelib.value.revert.changes.dialog");
    private final String configId;
    private final List<Component> description;
    private ValidationResult result = ValidationResult.ok();
    private IDescriptionRenderer renderer;
    private boolean lastHoverState;
    private long hoverTimeStart;

    public ConfigEntryWidget(int x, int y, int w, int h, ConfigValue<?> value, String configId) {
        super(x, y, w, h, (Component)Component.m_237115_((String)("config." + configId + ".option." + value.getId())));
        this.configId = configId;
        this.description = Arrays.stream(value.getDescription()).map(text -> Component.m_237113_((String)text).m_130940_(ChatFormatting.GRAY)).collect(Collectors.toList());
    }

    public void setDescriptionRenderer(IDescriptionRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public Component getComponentName() {
        return this.m_6035_();
    }

    public void m_168797_(NarrationElementOutput narrationElementOutput) {
    }

    @Override
    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Font font = Minecraft.m_91087_().f_91062_;
        if (!this.lastHoverState && this.f_93622_) {
            this.hoverTimeStart = System.currentTimeMillis();
        }
        boolean isError = !this.result.isOk();
        Component component = this.m_6035_();
        int n = this.m_252754_();
        float f = this.m_252907_();
        Objects.requireNonNull(font);
        graphics.m_280614_(font, component, n, (int)(f + (float)(this.f_93619_ - 9) / 2.0f), 0xAAAAAA, true);
        super.m_87963_(graphics, mouseX, mouseY, partialTicks);
        if ((isError || this.f_93622_) && this.renderer != null) {
            long totalHoverTime = System.currentTimeMillis() - this.hoverTimeStart;
            if (isError || totalHoverTime >= 750L) {
                NotificationSeverity severity = this.result.severity();
                MutableComponent textComponent = this.result.text().m_130940_(severity.getExtraFormatting());
                List<MutableComponent> desc = isError ? Collections.singletonList(textComponent) : this.description;
                List<FormattedCharSequence> split = desc.stream().flatMap(text -> font.m_92923_((FormattedText)text, this.f_93618_ / 2).stream()).collect(Collectors.toList());
                this.renderer.drawDescription(graphics, this, severity, split);
            }
        }
        this.lastHoverState = this.f_93622_;
    }

    @Override
    public void setValidationResult(ValidationResult result) {
        this.result = result;
    }

    @Override
    public <W extends AbstractWidget> W addConfigWidget(WidgetAdder.ToWidgetFunction<W> function) {
        W widget = function.asWidget(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, this.configId);
        return this.addRenderableWidget(widget);
    }

    @FunctionalInterface
    public static interface IDescriptionRenderer {
        public void drawDescription(GuiGraphics var1, AbstractWidget var2, NotificationSeverity var3, List<FormattedCharSequence> var4);
    }
}

