/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.config.client.screen;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.config.adapter.TypeAdapter;
import mod.azure.azurelib.config.adapter.TypeAdapters;
import mod.azure.azurelib.config.client.DisplayAdapter;
import mod.azure.azurelib.config.client.DisplayAdapterManager;
import mod.azure.azurelib.config.client.screen.AbstractConfigScreen;
import mod.azure.azurelib.config.client.widget.ConfigEntryWidget;
import mod.azure.azurelib.config.validate.NotificationSeverity;
import mod.azure.azurelib.config.value.ArrayValue;
import mod.azure.azurelib.config.value.ConfigValue;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class ArrayConfigScreen<V, C extends ConfigValue<V>>
extends AbstractConfigScreen {
    public static final Component ADD_ELEMENT = Component.m_237115_((String)"text.azurelib.value.add_element");
    public final C array;
    private final boolean fixedSize;
    private Supplier<Integer> sizeSupplier = () -> 0;
    private DummyConfigValueFactory valueFactory;
    private ElementAddHandler addHandler;
    private ElementRemoveHandler<V> removeHandler;

    public ArrayConfigScreen(String ownerIdentifier, String configId, C array, Screen previous) {
        super((Component)Component.m_237115_((String)String.format("config.%s.option.%s", configId, ownerIdentifier)), previous, configId);
        this.array = array;
        this.fixedSize = ((ArrayValue)array).isFixedSize();
    }

    public void fetchSize(Supplier<Integer> integerSupplier) {
        this.sizeSupplier = integerSupplier;
    }

    public void valueFactory(DummyConfigValueFactory factory) {
        this.valueFactory = factory;
    }

    public void addElement(ElementAddHandler handler) {
        this.addHandler = handler;
    }

    public void removeElement(ElementRemoveHandler<V> handler) {
        this.removeHandler = handler;
    }

    protected void m_7856_() {
        int viewportMin = 35;
        int viewportHeight = this.f_96544_ - 35 - 30;
        this.pageSize = (viewportHeight - 20) / 25;
        this.correctScrollingIndex(this.sizeSupplier.get());
        int errorOffset = viewportHeight - 20 - (this.pageSize * 25 - 5);
        int offset = 0;
        Class<?> compType = ((ConfigValue)this.array).get().getClass().getComponentType();
        DisplayAdapter adapter = DisplayAdapterManager.forType(compType);
        TypeAdapter.AdapterContext context = ((ConfigValue)this.array).getSerializationContext();
        Field owner = context.getOwner();
        for (int i = this.index; i < this.index + this.pageSize; ++i) {
            int j = i - this.index;
            if (i >= this.sizeSupplier.get()) break;
            int correct = errorOffset / (this.pageSize - j);
            errorOffset -= correct;
            ConfigValue<?> dummy = this.valueFactory.create(((ConfigValue)this.array).getId(), i);
            dummy.processFieldData(owner);
            ConfigEntryWidget widget = (ConfigEntryWidget)this.m_142416_((GuiEventListener)new ConfigEntryWidget(30, 45 + j * 25 + (offset += correct), this.f_96543_ - 60, 20, dummy, this.configId));
            widget.setDescriptionRenderer((graphics, widget1, severity, text) -> this.renderEntryDescription(graphics, widget1, severity, text));
            if (adapter == null) {
                AzureLib.LOGGER.error(MARKER, "Missing display adapter for {} type, will not be displayed in GUI", (Object)compType.getSimpleName());
                continue;
            }
            try {
                adapter.placeWidgets(dummy, owner, widget);
                this.initializeGuiValue(dummy, widget);
            }
            catch (ClassCastException e) {
                AzureLib.LOGGER.error(MARKER, "Unable to create config field for {} type due to error {}", (Object)compType.getSimpleName(), (Object)e);
            }
            if (this.fixedSize) continue;
            int elementIndex = i;
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"x"), btn -> {
                this.removeHandler.removeElementAt(elementIndex, (index, src, dest) -> {
                    System.arraycopy(src, 0, dest, 0, index);
                    System.arraycopy(src, index + 1, dest, index, this.sizeSupplier.get() - 1 - index);
                    return dest;
                });
                this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            }).m_252794_(this.f_96543_ - 28, widget.m_252907_()).m_253046_(20, 20).m_253136_());
        }
        this.addFooter();
    }

    private void renderEntryDescription(GuiGraphics graphics, AbstractWidget widget, NotificationSeverity severity, List<FormattedCharSequence> text) {
        if (!severity.isOkStatus()) {
            this.renderNotification(severity, graphics, text, widget.m_252754_() + 5, widget.m_252907_() + widget.m_93694_() + 10);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        int titleWidth = this.f_96547_.m_92852_((FormattedText)this.f_96539_);
        int n = (int)((float)(this.f_96543_ - titleWidth) / 2.0f);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280614_(this.f_96547_, this.f_96539_, n, (int)((float)(35 - 9) / 2.0f), 0xFFFFFF, true);
        graphics.m_280509_(0, 35, this.f_96543_, this.f_96544_ - 30, -1728053248);
        ArrayConfigScreen.renderScrollbar(graphics, this.f_96543_ - 5, 35, 5, this.f_96544_ - 30 - 35, this.index, this.sizeSupplier.get(), this.pageSize);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void addFooter() {
        super.addFooter();
        if (!this.fixedSize) {
            int centerY = this.f_96544_ - 30 + 5;
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)ADD_ELEMENT, btn -> {
                this.addHandler.insertElement();
                this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            }).m_252794_(this.f_96543_ - 100, centerY).m_253046_(80, 20).m_253136_());
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        int scale = (int)(-amount);
        int next = this.index + scale;
        if (next >= 0 && next + this.pageSize <= this.sizeSupplier.get()) {
            this.index = next;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            return true;
        }
        return false;
    }

    public static <V> TypeAdapter.AdapterContext callbackCtx(Field parent, Class<V> componentType, BiConsumer<V, Integer> callback, int index) {
        return new DummyCallbackAdapter<V>(componentType, parent, callback, index);
    }

    @FunctionalInterface
    public static interface DummyConfigValueFactory {
        public ConfigValue<?> create(String var1, int var2);
    }

    @FunctionalInterface
    public static interface ElementAddHandler {
        public void insertElement();
    }

    @FunctionalInterface
    public static interface ElementRemoveHandler<V> {
        public void removeElementAt(int var1, ArrayTrimmer<V> var2);

        @FunctionalInterface
        public static interface ArrayTrimmer<V> {
            public V trim(int var1, V var2, V var3);
        }
    }

    private static class DummyCallbackAdapter<V>
    implements TypeAdapter.AdapterContext {
        private final TypeAdapter typeAdapter;
        private final Field parentField;
        private final BiConsumer<V, Integer> setCallback;
        private final int index;

        private DummyCallbackAdapter(Class<V> type, Field parentField, BiConsumer<V, Integer> setCallback, int index) {
            this.typeAdapter = TypeAdapters.forType(type);
            this.parentField = parentField;
            this.setCallback = setCallback;
            this.index = index;
        }

        @Override
        public TypeAdapter getAdapter() {
            return this.typeAdapter;
        }

        @Override
        public Field getOwner() {
            return this.parentField;
        }

        @Override
        public void setFieldValue(Object value) {
            this.setCallback.accept(value, this.index);
        }
    }
}

