/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.forge.platform;

import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import mezz.jei.common.platform.IPlatformRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public class RegistryWrapper<T>
implements IPlatformRegistry<T> {
    private final ForgeRegistry<T> forgeRegistry;

    public static <T, V> IPlatformRegistry<T> getRegistry(ResourceKey<? extends Registry<T>> key) {
        RegistryWrapper<T> registryWrapper;
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(key.m_135782_());
        RegistryWrapper<T> castRegistry = registryWrapper = new RegistryWrapper<T>(registry);
        return castRegistry;
    }

    private RegistryWrapper(ForgeRegistry<T> forgeRegistry) {
        this.forgeRegistry = forgeRegistry;
    }

    @Override
    public Stream<T> getValues() {
        return StreamSupport.stream(this.forgeRegistry.spliterator(), false);
    }

    @Override
    public Optional<T> getValue(ResourceLocation resourceLocation) {
        Object value = this.forgeRegistry.getValue(resourceLocation);
        return Optional.ofNullable(value);
    }

    @Override
    public int getId(T entry) {
        return this.forgeRegistry.getID(entry);
    }

    @Override
    public Optional<T> getValue(int id) {
        Object value = this.forgeRegistry.getValue(id);
        return Optional.ofNullable(value);
    }

    @Override
    public boolean contains(T entry) {
        return this.forgeRegistry.containsValue(entry);
    }

    @Override
    public Optional<ResourceLocation> getRegistryName(T entry) {
        return this.forgeRegistry.getResourceKey(entry).map(ResourceKey::m_135782_);
    }
}

