/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.technomancy;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.events.SpellHealEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSSchoolRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@AutoSpellConfig
public class RebootSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"reboot");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(CSSchoolRegistry.TECHNOMANCY_RESOURCE).setMaxLevel(8).setCooldownSeconds(50.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.healing", (Object[])new Object[]{Utils.stringTruncation((double)this.getHealing(spellLevel, caster), (int)2)}), Component.m_237110_((String)"ui.cataclysm_spellbooks.summon_healing", (Object[])new Object[]{Utils.stringTruncation((double)((double)this.getHealing(spellLevel, caster) / 2.0), (int)2)}));
    }

    public RebootSpell() {
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 5;
        this.spellPowerPerLevel = 1;
        this.castTime = 10;
        this.baseManaCost = 20;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        float radius = spellLevel;
        float distance = 1.65f;
        float healAmount = this.getHealing(spellLevel, entity);
        float allyHealAmount = (float)this.getHealing(spellLevel, entity) / 2.0f;
        Vec3 hitLocation = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() * 0.3f), 0.0).m_82549_(entity.m_20156_().m_82542_((double)distance, (double)0.35f, (double)distance));
        List entities = level.m_45933_((Entity)entity, AABB.m_165882_((Vec3)hitLocation, (double)(radius * 2.0f), (double)radius, (double)(radius * 2.0f)));
        for (Entity target : entities) {
            LivingEntity livingEntity;
            if (!entity.m_6087_() || !(entity.m_20280_(target) < (double)(radius * radius)) || !Utils.hasLineOfSight((Level)level, (Vec3)entity.m_146892_(), (Vec3)target.m_20191_().m_82399_(), (boolean)false) || !(target instanceof LivingEntity) || !(livingEntity = (LivingEntity)target).m_7307_((Entity)entity)) continue;
            MinecraftForge.EVENT_BUS.post((Event)new SpellHealEvent(entity, entity, allyHealAmount, this.getSchoolType()));
            livingEntity.m_5634_(allyHealAmount);
            this.makeParticleCircle(livingEntity);
        }
        MinecraftForge.EVENT_BUS.post((Event)new SpellHealEvent(entity, entity, healAmount, this.getSchoolType()));
        entity.m_5634_(healAmount);
        this.makeParticleCircle(entity);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private int getHealing(int spellLevel, LivingEntity entity) {
        return (int)(this.getSpellPower(spellLevel, (Entity)entity) * 0.5f);
    }

    private void makeParticleCircle(LivingEntity entity) {
        int count = 16;
        float particleRadius = 1.25f;
        for (int i = 0; i < count; ++i) {
            double theta = Math.toRadians(360.0 / (double)count) * (double)i;
            double x = Math.cos(theta) * (double)particleRadius;
            double z = Math.sin(theta) * (double)particleRadius;
            MagicManager.spawnParticles((Level)entity.m_9236_(), (ParticleOptions)ParticleHelper.ELECTRICITY, (double)(entity.m_20182_().f_82479_ + x), (double)entity.m_20182_().f_82480_, (double)(entity.m_20182_().f_82481_ + z), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.1, (boolean)false);
        }
    }
}

