/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.technomancy;

import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModSounds;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.List;
import java.util.Optional;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSParticleRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSPotionEffectRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSSchoolRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class LockOnSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"lock_on");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(CSSchoolRegistry.TECHNOMANCY_RESOURCE).setMaxLevel(5).setCooldownSeconds(30.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.effect_length", (Object[])new Object[]{Utils.timeFromTicks((float)this.getEffectDuration(spellLevel, caster), (int)1)}));
    }

    public LockOnSpell() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 5;
        this.baseManaCost = 25;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)ModSounds.EMP_ACTIVATED.get());
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        return Utils.preCastTargetHelper((Level)level, (LivingEntity)entity, (MagicData)playerMagicData, (AbstractSpell)this, (int)32, (float)0.15f);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        TargetEntityCastData targetingData;
        LivingEntity targetEntity;
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof TargetEntityCastData && (targetEntity = (targetingData = (TargetEntityCastData)iCastData).getTarget((ServerLevel)level)) != null) {
            if (!targetEntity.m_21023_((MobEffect)CSPotionEffectRegistry.SHUTDOWN_EFFECT.get())) {
                this.spawnParticles(targetEntity);
                targetEntity.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.GUIDING_BOLT.get(), this.getEffectDuration(spellLevel, entity)));
                targetEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffect.EFFECTSTUN.get(), this.getEffectDuration(spellLevel, entity)));
                targetEntity.m_7292_(new MobEffectInstance((MobEffect)CSPotionEffectRegistry.INCAPACITATED_EFFECT.get(), this.getEffectDuration(spellLevel, entity)));
            } else {
                targetEntity.m_21195_((MobEffect)CSPotionEffectRegistry.SHUTDOWN_EFFECT.get());
                this.spawnParticles(targetEntity);
                targetEntity.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.GUIDING_BOLT.get(), this.getEffectDuration(spellLevel, entity)));
                targetEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffect.EFFECTSTUN.get(), this.getEffectDuration(spellLevel, entity)));
                targetEntity.m_7292_(new MobEffectInstance((MobEffect)CSPotionEffectRegistry.INCAPACITATED_EFFECT.get(), this.getEffectDuration(spellLevel, entity)));
            }
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public int getEffectDuration(int spellLevel, LivingEntity caster) {
        int amount = (int)Mth.m_14036_((float)(this.getSpellPower(spellLevel, (Entity)caster) * 20.0f), (float)20.0f, (float)100.0f);
        return amount;
    }

    private void spawnParticles(LivingEntity entity) {
        ServerLevel level = (ServerLevel)entity.m_9236_();
        level.m_8767_((ParticleOptions)((SimpleParticleType)CSParticleRegistry.TARGET_PARTICLE.get()), entity.m_20185_(), entity.m_20186_() + 2.5, entity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
    }
}

