/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.technomancy;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.entity.spells.flash_bang.FlashBangProjectileEntity;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSSchoolRegistry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class FlashBangSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"flash_bang");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(CSSchoolRegistry.TECHNOMANCY_RESOURCE).setMaxLevel(8).setCooldownSeconds(20.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.radius", (Object[])new Object[]{Float.valueOf(this.getRadius(spellLevel))}), Component.m_237110_((String)"ui.irons_spellbooks.effect_length", (Object[])new Object[]{this.getEffectDuration(spellLevel, caster)}));
    }

    public FlashBangSpell() {
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 2;
        this.spellPowerPerLevel = 2;
        this.castTime = 0;
        this.baseManaCost = 25;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        FlashBangProjectileEntity flashBang = new FlashBangProjectileEntity(level, entity);
        flashBang.m_146884_(entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_() + 0.5 - flashBang.m_20191_().m_82376_() * 0.5, 0.0));
        flashBang.m_37251_((Entity)entity, entity.m_146909_(), entity.m_6080_(), 0.0f, 0.5f, 0.8f);
        flashBang.setExplosionRadius(this.getRadius(spellLevel));
        flashBang.setEffectDuration(this.getEffectDuration(spellLevel, entity));
        level.m_7967_((Entity)flashBang);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public float getRadius(int spellLevel) {
        return (float)spellLevel / 2.0f;
    }

    public int getEffectDuration(int spellLevel, LivingEntity caster) {
        return (int)((double)this.getSpellPower(spellLevel, (Entity)caster) * 0.8);
    }
}

