/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.technomancy;

import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import io.redspace.ironsspellbooks.effect.MagicMobEffect;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSSchoolRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.spells.CSSpellAnimations;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class DDoSSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"ddos");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(CSSchoolRegistry.TECHNOMANCY_RESOURCE).setMaxLevel(8).setCooldownSeconds(200.0).build();

    public DDoSSpell() {
        this.manaCostPerLevel = 15;
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 2;
        this.castTime = 25;
        this.baseManaCost = 150;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public AnimationHolder getCastStartAnimation() {
        return CSSpellAnimations.ANIMATION_CHARGED_GROUND_SLAM;
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.pass();
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        float radius = this.getRange(spellLevel);
        float distance = 2.0f;
        Vec3 ddosLocation = entity.m_20182_().m_82549_(entity.m_20156_().m_82542_((double)distance, (double)0.3f, (double)distance));
        ScreenShake_Entity.ScreenShake((Level)level, (Vec3)entity.m_20182_(), (float)radius, (float)0.15f, (int)0, (int)20);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)CSSchoolRegistry.TECHNOMANCY.get()).getTargetingColor(), (float)this.getRange(spellLevel - 3)), (double)entity.m_20185_(), (double)(entity.m_20186_() + (double)0.8f), (double)entity.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)CSSchoolRegistry.TECHNOMANCY.get()).getTargetingColor(), (float)this.getRange(spellLevel)), (double)entity.m_20185_(), (double)(entity.m_20186_() + 0.5), (double)entity.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)CSSchoolRegistry.TECHNOMANCY.get()).getTargetingColor(), (float)this.getRange(spellLevel - 3)), (double)entity.m_20185_(), (double)(entity.m_20186_() + (double)0.2f), (double)entity.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        List entities = level.m_45933_((Entity)entity, AABB.m_165882_((Vec3)ddosLocation, (double)(radius * 2.0f), (double)radius, (double)(radius * 2.0f)));
        for (Entity target : entities) {
            if (target instanceof AntiMagicSusceptible) {
                AntiMagicSusceptible antiMagicSusceptible = (AntiMagicSusceptible)target;
                if (antiMagicSusceptible instanceof IMagicSummon) {
                    IMagicSummon summon = (IMagicSummon)antiMagicSusceptible;
                    if (summon.getSummoner() == entity) {
                        antiMagicSusceptible.onAntiMagic(playerMagicData);
                    } else {
                        antiMagicSusceptible.onAntiMagic(playerMagicData);
                    }
                } else {
                    antiMagicSusceptible.onAntiMagic(playerMagicData);
                }
            } else if (target instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)target;
                Utils.serverSideCancelCast((ServerPlayer)player, (boolean)true);
                MagicData.getPlayerMagicData((LivingEntity)player).getPlayerRecasts().removeAll(RecastResult.COUNTERSPELL);
            } else if (target instanceof IMagicEntity) {
                IMagicEntity abstractSpellCastingMob = (IMagicEntity)target;
                abstractSpellCastingMob.cancelCast();
            }
            if (!(target instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)target;
            for (MobEffect mobEffect : livingEntity.m_21221_().keySet().stream().toList()) {
                if (!(mobEffect instanceof MagicMobEffect)) continue;
                MagicMobEffect magicMobEffect = (MagicMobEffect)mobEffect;
                livingEntity.m_21195_((MobEffect)magicMobEffect);
            }
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private int getRange(int spellLevel) {
        return (int)((float)spellLevel * 1.2f);
    }
}

