/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.technomancy;

import com.github.L_Ender.cataclysm.entity.projectile.Wither_Missile_Entity;
import com.github.L_Ender.cataclysm.init.ModEntities;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.spells.target_area.TargetedAreaEntity;
import io.redspace.ironsspellbooks.spells.TargetAreaCastData;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSSchoolRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.spells.technomancy.AbstractHarbingerSpell;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class AerialAssaultSpell
extends AbstractHarbingerSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"aerial_assault");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(CSSchoolRegistry.TECHNOMANCY_RESOURCE).setMaxLevel(10).setCooldownSeconds(25.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}), Component.m_237110_((String)"ui.irons_spellbooks.radius", (Object[])new Object[]{Utils.stringTruncation((double)this.getRadius(spellLevel, caster), (int)1)}));
    }

    public AerialAssaultSpell() {
        this.manaCostPerLevel = 1;
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 2;
        this.castTime = 160;
        this.baseManaCost = 5;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.CONTINUOUS;
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.CHARGE_WAVY_ANIMATION;
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.ANIMATION_LONG_CAST_FINISH;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (!(playerMagicData.getAdditionalCastData() instanceof TargetAreaCastData)) {
            Vec3 targetArea = Utils.moveToRelativeGroundLevel((Level)level, (Vec3)Utils.raycastForEntity((Level)level, (Entity)entity, (float)40.0f, (boolean)true).m_82450_(), (int)12);
            playerMagicData.setAdditionalCastData((ICastData)new TargetAreaCastData(targetArea, TargetedAreaEntity.createTargetAreaEntity((Level)level, (Vec3)targetArea, (float)this.getRadius(spellLevel, entity), (int)16388147)));
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        ICastData iCastData;
        if (playerMagicData != null && (playerMagicData.getCastDurationRemaining() + 1) % 4 == 0 && (iCastData = playerMagicData.getAdditionalCastData()) instanceof TargetAreaCastData) {
            TargetAreaCastData targetAreaCastData = (TargetAreaCastData)iCastData;
            float radius = this.getRadius(spellLevel, entity);
            Vec3 center = targetAreaCastData.getCenter();
            Vec3 spawn = center.m_82549_(new Vec3(0.0, entity.m_20186_(), (double)(entity.m_217043_().m_188501_() * radius)).m_82524_((float)entity.m_217043_().m_188503_(360)));
            spawn = this.raiseWithCollision(spawn, 12, level);
            for (int i = 0; i < spellLevel; ++i) {
                this.shootMissiles(level, entity, spellLevel, spawn);
            }
        }
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
    }

    private Vec3 raiseWithCollision(Vec3 start, int blocks, Level level) {
        Vec3 raised;
        for (int i = 0; i < blocks && level.m_8055_(BlockPos.m_274446_((Position)(raised = start.m_82520_(0.0, 1.0, 0.0)))).m_60795_(); ++i) {
            start = raised;
        }
        return start;
    }

    public void shootMissiles(Level level, LivingEntity caster, int spellLevel, Vec3 spawn) {
        Vec3 offset = Utils.getRandomVec3((double)1.0).m_82541_().m_82490_((double)0.075f);
        float d = caster.m_146909_();
        float d2 = -Mth.m_14031_((float)(d * ((float)Math.PI / 180)));
        Wither_Missile_Entity missile = new Wither_Missile_Entity((EntityType)ModEntities.WITHER_MISSILE.get(), caster, spawn.m_82549_((Vec3)offset).f_82479_, spawn.m_82549_((Vec3)offset).f_82480_, spawn.m_82549_((Vec3)offset).f_82481_, 0.0, (double)d2, 0.0, this.getDamage(spellLevel, caster), level);
        level.m_7967_((Entity)missile);
    }

    private float getDamage(int spellLevel, LivingEntity entity) {
        return this.getSpellPower(spellLevel, (Entity)entity) * 0.5f;
    }

    private float getQuakeDamage(int spellLevel, LivingEntity entity) {
        return this.getSpellPower(spellLevel, (Entity)entity) * 0.25f;
    }

    private float getRadius(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) / 5.0f;
    }
}

