/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.nature;

import com.github.L_Ender.cataclysm.entity.effect.Sandstorm_Entity;
import com.github.L_Ender.cataclysm.init.ModSounds;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import java.util.Optional;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSPotionEffectRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.spells.CSSpellAnimations;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class PharaohsWrathSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"pharaohs_wrath");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.NATURE_RESOURCE).setMaxLevel(3).setCooldownSeconds(120.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.effect_length", (Object[])new Object[]{Utils.timeFromTicks((float)(this.getSpellPower(spellLevel, (Entity)caster) * 20.0f), (int)1)}), Component.m_237110_((String)"attribute.modifier.plus.1", (Object[])new Object[]{Utils.stringTruncation((double)this.getPercentageAttackDamage(spellLevel, caster), (int)0), Component.m_237115_((String)"attribute.name.generic.attack_damage")}), Component.m_237110_((String)"attribute.modifier.plus.1", (Object[])new Object[]{Utils.stringTruncation((double)this.getPercentageSpellPower(spellLevel, caster), (int)0), Component.m_237115_((String)"attribute.irons_spellbooks.spell_power")}), Component.m_237115_((String)"ui.cataclysm_spellbooks.kings_wrath_strikes"));
    }

    public PharaohsWrathSpell() {
        this.manaCostPerLevel = 20;
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 5;
        this.castTime = 0;
        this.baseManaCost = 95;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public boolean canBeCraftedBy(Player player) {
        return false;
    }

    public boolean allowLooting() {
        return false;
    }

    public boolean allowCrafting() {
        return false;
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)ModSounds.REMNANT_ROAR.get());
    }

    public AnimationHolder getCastStartAnimation() {
        return CSSpellAnimations.ANIMATION_WRATH_ROAR;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        entity.m_7292_(new MobEffectInstance((MobEffect)CSPotionEffectRegistry.KINGS_WRATH_EFFECT.get(), (int)(this.getSpellPower(spellLevel, (Entity)entity) * 40.0f), spellLevel - 1, false, false, true));
        for (int i = 0; i < 3; ++i) {
            double casterX = entity.m_20185_();
            double casterY = entity.m_20186_();
            double casterZ = entity.m_20189_();
            float angle = (float)((double)i * Math.PI / 1.5);
            double stormX = casterX + (double)(Mth.m_14089_((float)angle) * 4.0f);
            double stormZ = casterZ + (double)(Mth.m_14031_((float)angle) * 4.0f);
            Sandstorm_Entity sandstorm = new Sandstorm_Entity(level, stormX, casterY, stormZ, (int)(this.getSpellPower(spellLevel, (Entity)entity) * 40.0f), angle, entity);
            level.m_7967_((Entity)sandstorm);
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private float getPercentageAttackDamage(int spellLevel, LivingEntity caster) {
        return (float)spellLevel * 0.2f * 100.0f;
    }

    private float getPercentageSpellPower(int spellLevel, LivingEntity caster) {
        return (float)spellLevel * 0.05f * 100.0f;
    }
}

