/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.fire;

import com.github.L_Ender.cataclysm.entity.projectile.Flare_Bomb_Entity;
import com.github.L_Ender.cataclysm.init.ModEntities;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import java.util.Timer;
import java.util.TimerTask;
import net.acetheeldritchking.cataclysm_spellbooks.util.CSUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class CometShowerSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"comet_shower");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.FIRE_RESOURCE).setMaxLevel(8).setCooldownSeconds(30.0).build();

    public CometShowerSpell() {
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 3;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 40;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public void onCast(final Level level, int spellLevel, final LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        final Timer flareTimer = new Timer();
        int flareTimerDelay = 350;
        for (int i = 0; i < spellLevel; ++i) {
            int delay = i * flareTimerDelay;
            flareTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Flare_Bomb_Entity flareBomb = new Flare_Bomb_Entity((EntityType)ModEntities.FLARE_BOMB.get(), level, entity);
                    Vec3 viewVec = entity.m_20252_(1.0f);
                    flareBomb.m_20343_(entity.m_20185_() + 0.5, CSUtils.getEyeHeight(entity), entity.m_20189_() + 0.5);
                    flareBomb.m_6686_(viewVec.f_82479_, viewVec.f_82480_, viewVec.f_82481_, 1.0f, 1.0f);
                    level.m_7967_((Entity)flareBomb);
                }
            }, delay);
            flareTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    flareTimer.cancel();
                }
            }, (long)spellLevel * (long)flareTimerDelay);
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }
}

