/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.fire;

import com.github.L_Ender.cataclysm.entity.projectile.Blazing_Bone_Entity;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.spells.fire.AbstractIgnisSpell;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class BoneStormSpell
extends AbstractIgnisSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"bone_storm");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(SchoolRegistry.FIRE_RESOURCE).setMaxLevel(5).setCooldownSeconds(10.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.cataclysm_spellbooks.bone_speed_1", (Object[])new Object[]{Utils.stringTruncation((double)this.getBoneSpeed(0.2f, spellLevel), (int)2)}), Component.m_237110_((String)"ui.cataclysm_spellbooks.bone_speed_2", (Object[])new Object[]{Utils.stringTruncation((double)this.getBoneSpeed(0.3f, spellLevel), (int)2)}), Component.m_237110_((String)"ui.cataclysm_spellbooks.bone_speed_3", (Object[])new Object[]{Utils.stringTruncation((double)this.getBoneSpeed(0.1f, spellLevel), (int)2)}), Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel), (int)2)}));
    }

    public BoneStormSpell() {
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 0;
        this.spellPowerPerLevel = 1;
        this.castTime = 100;
        this.baseManaCost = 10;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.CONTINUOUS;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        this.launchBone1(entity, spellLevel, level);
        this.launchBone2(entity, spellLevel, level);
        this.launchBone3(entity, spellLevel, level);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void launchBone1(LivingEntity caster, int spellLevel, Level level) {
        caster.m_5496_(SoundEvents.f_12520_, 1.0f, 0.75f);
        for (int i = 0; i < 8; ++i) {
            float throwAngle = (float)((double)i * Math.PI / 4.0);
            double casterX = caster.m_20185_() + (double)Mth.m_14089_((float)throwAngle);
            double casterY = caster.m_20186_() + (double)caster.m_20206_() * 0.62;
            double casterZ = caster.m_20189_() + (double)Mth.m_14031_((float)throwAngle);
            double angleX = Mth.m_14089_((float)throwAngle);
            double angleY = 0.2;
            double angleZ = Mth.m_14031_((float)throwAngle);
            Blazing_Bone_Entity blazingBone = new Blazing_Bone_Entity(level, this.getDamage(spellLevel), caster);
            blazingBone.m_7678_(casterX, casterY, casterZ, (float)i * 45.0f, caster.m_146909_());
            float speed = 0.3f;
            float speedSpellLevel = this.getBoneSpeed(speed, spellLevel);
            blazingBone.m_20242_(true);
            blazingBone.m_6686_(angleX, angleY, angleZ, speedSpellLevel, 1.0f);
            level.m_7967_((Entity)blazingBone);
        }
    }

    private void launchBone2(LivingEntity caster, int spellLevel, Level level) {
        caster.m_5496_(SoundEvents.f_12520_, 1.0f, 0.75f);
        for (int i = 0; i < 6; ++i) {
            float throwAngle = (float)((double)i * Math.PI / 3.0);
            double casterX = caster.m_20185_() + (double)Mth.m_14089_((float)throwAngle);
            double casterY = caster.m_20186_() + (double)caster.m_20206_() * 0.62;
            double casterZ = caster.m_20189_() + (double)Mth.m_14031_((float)throwAngle);
            double angleX = Mth.m_14089_((float)throwAngle);
            double angleY = 0.1;
            double angleZ = Mth.m_14031_((float)throwAngle);
            Blazing_Bone_Entity blazingBone = new Blazing_Bone_Entity(level, this.getDamage(spellLevel), caster);
            blazingBone.m_7678_(casterX, casterY, casterZ, (float)i * 60.0f, caster.m_146909_());
            float speed = 0.4f;
            float speedSpellLevel = this.getBoneSpeed(speed, spellLevel);
            blazingBone.m_20242_(true);
            blazingBone.m_6686_(angleX, angleY, angleZ, speedSpellLevel, 1.0f);
            level.m_7967_((Entity)blazingBone);
        }
    }

    private void launchBone3(LivingEntity caster, int spellLevel, Level level) {
        caster.m_5496_(SoundEvents.f_12520_, 1.0f, 0.75f);
        for (int i = 0; i < 10; ++i) {
            float throwAngle = (float)((double)i * Math.PI / 5.0);
            double casterX = caster.m_20185_() + (double)Mth.m_14089_((float)throwAngle);
            double casterY = caster.m_20186_() + (double)caster.m_20206_() * 0.62;
            double casterZ = caster.m_20189_() + (double)Mth.m_14031_((float)throwAngle);
            double angleX = Mth.m_14089_((float)throwAngle);
            double angleY = 0.1;
            double angleZ = Mth.m_14031_((float)throwAngle);
            Blazing_Bone_Entity blazingBone = new Blazing_Bone_Entity(level, this.getDamage(spellLevel), caster);
            blazingBone.m_7678_(casterX, casterY, casterZ, (float)i * 36.0f, caster.m_146909_());
            float speed = 0.2f;
            float speedSpellLevel = this.getBoneSpeed(speed, spellLevel);
            blazingBone.m_20242_(true);
            blazingBone.m_6686_(angleX, angleY, angleZ, speedSpellLevel, 1.0f);
            level.m_7967_((Entity)blazingBone);
        }
    }

    private float getBoneSpeed(float speed, int spellLevel) {
        return speed * (float)spellLevel;
    }

    private float getDamage(int spellLevel) {
        return (float)((double)spellLevel * 1.5);
    }
}

