/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.ender;

import com.github.L_Ender.cataclysm.entity.projectile.Void_Rune_Entity;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

@AutoSpellConfig
public class VoidRuneBulwarkSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"void_bulwark");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.ENDER_RESOURCE).setMaxLevel(5).setCooldownSeconds(50.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.ring_count", (Object[])new Object[]{this.getRings(spellLevel)}), Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)1)}));
    }

    public VoidRuneBulwarkSpell() {
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 4;
        this.spellPowerPerLevel = 2;
        this.castTime = 20;
        this.baseManaCost = 50;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        this.spawnVoidRuneCircle(level, entity, spellLevel);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void spawnVoidRune(Level level, double x, double z, double minY, double maxY, double rotation, int delay, LivingEntity caster, int spellLevel) {
        BlockPos blockPos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockState1;
            VoxelShape voxelShape;
            BlockPos blockPos1;
            BlockState blockState;
            if (!(blockState = level.m_8055_(blockPos1 = blockPos.m_7495_())).m_60783_((BlockGetter)level, blockPos1, Direction.UP)) continue;
            if (!level.m_46859_(blockPos) && !(voxelShape = (blockState1 = level.m_8055_(blockPos)).m_60812_((BlockGetter)level, blockPos)).m_83281_()) {
                d0 = voxelShape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockPos = blockPos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            Void_Rune_Entity voidRune = new Void_Rune_Entity(level, x, (double)blockPos.m_123342_() + d0, z, (float)rotation, delay, this.getDamage(spellLevel, caster), caster);
            level.m_7967_((Entity)voidRune);
        }
    }

    private void spawnVoidRuneCircle(Level level, LivingEntity caster, int spellLevel) {
        double casterX = caster.m_20185_();
        double casterY = caster.m_20186_();
        double casterZ = caster.m_20189_();
        double casterHeadY = casterY + 1.0;
        int casterYPosition = Mth.m_14107_((double)(casterY - 3.0));
        int numRings = spellLevel;
        double count = 1.0;
        int entitiesPerRing = Mth.m_14045_((int)((int)this.getSpellPower(spellLevel, (Entity)caster)), (int)1, (int)50);
        int warmUp = 0;
        for (int rings = 0; rings < numRings; ++rings) {
            double radius = count + (double)rings * 1.5;
            int entitiesInRing = entitiesPerRing + rings * 4;
            int increaseWarmUp = warmUp + rings * 5;
            for (int i = 0; i < entitiesInRing; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)entitiesInRing;
                double x = casterX + (double)Mth.m_14089_((float)((float)angle)) * radius;
                double z = casterZ + (double)Mth.m_14031_((float)((float)angle)) * radius;
                this.spawnVoidRune(level, x, z, casterYPosition, casterHeadY, angle, increaseWarmUp, caster, spellLevel);
            }
        }
    }

    private int getRings(int spellLevel) {
        return spellLevel;
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) / 2.0f;
    }
}

