/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.blood;

import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import io.redspace.ironsspellbooks.entity.spells.blood_needle.BloodNeedle;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.acetheeldritchking.cataclysm_spellbooks.entity.spells.blood_crystal.BloodCrystalProjectile;
import net.acetheeldritchking.cataclysm_spellbooks.spells.CSSpellAnimations;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class HemorrhagingImpactSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"hemorrhaging_impact");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.BLOOD_RESOURCE).setMaxLevel(1).setCooldownSeconds(120.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}), Component.m_237110_((String)"ui.cataclysm_spellbooks.needle_damage", (Object[])new Object[]{Utils.stringTruncation((double)(this.getDamage(spellLevel, caster) / 2.0f), (int)2)}));
    }

    public HemorrhagingImpactSpell() {
        this.manaCostPerLevel = 0;
        this.baseSpellPower = 25;
        this.spellPowerPerLevel = 0;
        this.castTime = 35;
        this.baseManaCost = 150;
    }

    public boolean canBeCraftedBy(Player player) {
        return false;
    }

    public boolean allowLooting() {
        return false;
    }

    public boolean allowCrafting() {
        return false;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public AnimationHolder getCastStartAnimation() {
        return CSSpellAnimations.ANIMATION_CHARGE_GUN_FULL;
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.pass();
    }

    public void onCast(final Level level, int spellLevel, final LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        BloodCrystalProjectile bloodSpear = new BloodCrystalProjectile(level, entity);
        bloodSpear.m_146884_(entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_() - bloodSpear.m_20191_().m_82376_() * 0.5, 0.0));
        bloodSpear.m_37251_((Entity)entity, entity.m_146909_(), entity.m_6080_(), 0.0f, 1.0f, 1.0f);
        final float damage = this.getDamage(spellLevel, entity);
        bloodSpear.setDamage(damage);
        bloodSpear.setExplosionRadius(3.0f);
        ScreenShake_Entity.ScreenShake((Level)level, (Vec3)entity.m_20182_(), (float)5.0f, (float)0.15f, (int)20, (int)20);
        level.m_7967_((Entity)bloodSpear);
        final Timer needleTimer = new Timer();
        int needleTimerDelay = 100;
        final int needleCount = 10;
        final int degrees = 360 / needleCount;
        final HitResult needleRaycast = Utils.raycastForEntity((Level)level, (Entity)entity, (float)32.0f, (boolean)true);
        for (int i = 0; i < needleCount; ++i) {
            int delay = needleCount * needleTimerDelay;
            needleTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    BloodNeedle needle = new BloodNeedle(level, entity);
                    int rot = degrees * needleCount - degrees / 2;
                    needle.setDamage(damage / 2.0f);
                    needle.setZRot((float)rot);
                    Vec3 spawn = entity.m_146892_().m_82549_(new Vec3(0.0, 1.5, 0.0).m_82535_((float)rot * ((float)Math.PI / 180)).m_82496_(-entity.m_146909_() * ((float)Math.PI / 180)).m_82524_(-entity.m_146908_() * ((float)Math.PI / 180)));
                    needle.m_20219_(spawn);
                    needle.shoot(needleRaycast.m_82450_().m_82546_(spawn).m_82541_());
                    level.m_7967_((Entity)needle);
                }
            }, delay);
            needleTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    needleTimer.cancel();
                }
            }, (long)(needleCount + 1) * (long)needleTimerDelay);
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public SpellDamageSource getDamageSource(Entity projectile, Entity attacker) {
        return super.getDamageSource(projectile, attacker).setLifestealPercent(0.75f);
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * 2.0f;
    }
}

