/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.abyssal;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSPotionEffectRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSSchoolRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.spells.abyssal.AbstractAbyssalSpell;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class AbyssalPredatorSpell
extends AbstractAbyssalSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"abyssal_predator");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(CSSchoolRegistry.ABYSSAL_RESOURCE).setMaxLevel(3).setCooldownSeconds(40.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.effect_length", (Object[])new Object[]{Utils.timeFromTicks((float)(this.getSpellPower(spellLevel, (Entity)caster) * 20.0f), (int)1)}), Component.m_237110_((String)"attribute.modifier.plus.1", (Object[])new Object[]{Utils.stringTruncation((double)this.getPercentageSwimSpeed(spellLevel, caster), (int)0), Component.m_237115_((String)"attribute.name.forge.swim_speed")}), Component.m_237110_((String)"attribute.modifier.plus.1", (Object[])new Object[]{Utils.stringTruncation((double)this.getPercentageAttackDamage(spellLevel, caster), (int)0), Component.m_237115_((String)"attribute.name.generic.attack_damage")}), Component.m_237110_((String)"attribute.modifier.plus.1", (Object[])new Object[]{Utils.stringTruncation((double)this.getPercentageAttackSpeed(spellLevel, caster), (int)0), Component.m_237115_((String)"attribute.name.generic.attack_speed")}));
    }

    public AbyssalPredatorSpell() {
        this.manaCostPerLevel = 25;
        this.baseSpellPower = 30;
        this.spellPowerPerLevel = 8;
        this.castTime = 0;
        this.baseManaCost = 55;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        entity.m_7292_(new MobEffectInstance((MobEffect)CSPotionEffectRegistry.ABYSSAL_PREDATOR_EFFECT.get(), (int)(this.getSpellPower(spellLevel, (Entity)entity) * 20.0f), spellLevel - 1, false, false, true));
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private float getPercentageSwimSpeed(int spellLevel, LivingEntity caster) {
        return (float)spellLevel * 0.4f * 100.0f;
    }

    private float getPercentageAttackDamage(int spellLevel, LivingEntity caster) {
        return (float)spellLevel * 0.2f * 100.0f;
    }

    private float getPercentageAttackSpeed(int spellLevel, LivingEntity caster) {
        return (float)spellLevel * 0.2f * 100.0f;
    }
}

