/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.items.armor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.UUID;
import net.acetheeldritchking.cataclysm_spellbooks.items.armor.CSArmorMaterials;
import net.acetheeldritchking.cataclysm_spellbooks.items.custom.CSItemDispatcher;
import net.acetheeldritchking.cataclysm_spellbooks.util.CSTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CSArmorItem
extends ArmorItem {
    private static final UUID[] ARMOR_ATTRIBUTE_UUID_PER_SLOT = new UUID[]{UUID.fromString("F7BFFA65-547A-49D2-8804-3D533070E432"), UUID.fromString("B05AF2C0-5862-4CE6-860A-522C11E1571A"), UUID.fromString("15C1FE6B-3596-412A-B6CF-4077CB37140F"), UUID.fromString("82A575D1-366A-4BBD-91F8-25DB6B804F06")};
    private final Multimap<Attribute, AttributeModifier> ARMOR_ATTRIBUTES;
    public final CSItemDispatcher dispatcher = new CSItemDispatcher();

    public CSArmorItem(CSArmorMaterials materialIn, ArmorItem.Type slot, Item.Properties settings) {
        super((ArmorMaterial)materialIn, slot, settings);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        float defense = materialIn.m_7366_(slot);
        float toughness = materialIn.m_6651_();
        float knockbackResistance = materialIn.m_6649_();
        UUID uuid = ARMOR_ATTRIBUTE_UUID_PER_SLOT[this.f_265916_.m_266308_().m_20749_()];
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)defense, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor toughness", (double)toughness, AttributeModifier.Operation.ADDITION));
        if (knockbackResistance > 0.0f) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", (double)knockbackResistance, AttributeModifier.Operation.ADDITION));
        }
        for (Map.Entry<Attribute, AttributeModifier> modifierEntry : materialIn.getAdditionalAttributes().entrySet()) {
            AttributeModifier atr = modifierEntry.getValue();
            atr = new AttributeModifier(uuid, atr.m_22214_(), atr.m_22218_(), atr.m_22217_());
            builder.put((Object)modifierEntry.getKey(), (Object)atr);
        }
        this.ARMOR_ATTRIBUTES = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        if (pEquipmentSlot == this.f_265916_.m_266308_()) {
            return this.ARMOR_ATTRIBUTES;
        }
        return ImmutableMultimap.of();
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            if (stack.m_41784_().m_128441_("az_id")) {
                player.m_6168_().forEach(wornArmor -> {
                    if (wornArmor != null && wornArmor.m_150930_((Item)this)) {
                        if (player.m_21255_() && wornArmor.m_204117_(CSTags.ARMORS_FOR_FLIGHT)) {
                            this.dispatcher.flight((Entity)player, (ItemStack)wornArmor);
                        } else if (!player.m_21255_() && wornArmor.m_204117_(CSTags.ARMORS_FOR_IDLE)) {
                            this.dispatcher.idle((Entity)player, (ItemStack)wornArmor);
                        }
                    }
                });
            }
        }
    }
}

