/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.entity.spells.parting_shot;

import com.github.L_Ender.cataclysm.client.particle.TrackLightningParticle;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.acetheeldritchking.cataclysm_spellbooks.entity.spells.no_man_zone.NoManZoneAoE;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSEntityRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSPotionEffectRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.SpellRegistries;
import net.acetheeldritchking.cataclysm_spellbooks.util.CSConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PartingShotProjectile
extends AbstractMagicProjectile
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public PartingShotProjectile(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_20242_(true);
    }

    public PartingShotProjectile(Level level, LivingEntity shooter) {
        this((EntityType<? extends Projectile>)((EntityType)CSEntityRegistry.PARTING_SHOT_PROJECTILE.get()), level);
        this.m_5602_((Entity)shooter);
    }

    public void trailParticles() {
        Vec3 vec3 = this.m_20182_().m_82546_(this.m_20184_());
        this.m_9236_().m_7106_((ParticleOptions)new TrackLightningParticle.OrbData(232, 59, 59), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    public void impactParticles(double x, double y, double z) {
    }

    public void travel() {
        this.m_146884_(this.m_20182_().m_82549_(this.m_20184_()));
        if (!this.m_20068_()) {
            Vec3 vec3 = this.m_20184_();
            this.m_20334_(vec3.f_82479_, vec3.f_82480_ - (double)0.05f, vec3.f_82481_);
        }
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_8119_() {
        Vec3 deltaMovement = this.m_20184_();
        double distance = deltaMovement.m_165924_();
        double x = deltaMovement.f_82479_;
        double y = deltaMovement.f_82480_;
        double z = deltaMovement.f_82481_;
        this.m_146922_((float)(Mth.m_14136_((double)x, (double)z) * 57.29577951308232));
        this.m_146926_((float)(Mth.m_14136_((double)y, (double)distance) * 57.29577951308232));
        this.m_146926_(PartingShotProjectile.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
        this.m_146922_(PartingShotProjectile.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
        Vec3 center = this.m_20182_().m_82549_(deltaMovement);
        Vec3 arcVec = center.m_82549_(new Vec3((double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() - 0.5f)));
        this.m_9236_().m_7106_((ParticleOptions)new TrackLightningParticle.OrbData(232, 59, 59), center.f_82479_, center.f_82480_, center.f_82481_, arcVec.f_82479_, arcVec.f_82480_, arcVec.f_82481_);
        super.m_8119_();
    }

    public float getSpeed() {
        return 0.45f;
    }

    public Optional<Supplier<SoundEvent>> getImpactSound() {
        return Optional.empty();
    }

    protected void m_5790_(EntityHitResult pResult) {
        Entity target = pResult.m_82443_();
        DamageSources.applyDamage((Entity)target, (float)this.damage, (DamageSource)((AbstractSpell)SpellRegistries.PARTING_SHOT.get()).getDamageSource((Entity)this, this.m_19749_()));
        pResult.m_82443_().f_19802_ = 0;
        int i = target.m_20094_();
        target.m_20254_(5);
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            livingTarget.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 100, 0, true, true, true));
            livingTarget.m_7292_(new MobEffectInstance((MobEffect)CSPotionEffectRegistry.DISABLED_EFFECT.get(), 100, 0, true, true, true));
        }
        if (!target.m_6469_((DamageSource)((AbstractSpell)SpellRegistries.PARTING_SHOT.get()).getDamageSource((Entity)this, this.m_19749_()), this.getDamage())) {
            target.m_7311_(i);
        }
        this.m_146870_();
    }

    protected void m_8060_(BlockHitResult pResult) {
        super.m_8060_(pResult);
        if (!this.m_9236_().f_46443_) {
            Entity entity = this.m_19749_();
            if (((Boolean)CSConfig.doSpellGriefing.get()).booleanValue()) {
                BlockPos pos = pResult.m_82425_().m_121945_(pResult.m_82434_());
                if (this.m_9236_().m_46859_(pos)) {
                    this.m_9236_().m_46597_(pos, BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)pos));
                }
            } else if (!(entity instanceof Mob) || ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)entity)) {
                BlockPos pos = pResult.m_82425_().m_121945_(pResult.m_82434_());
                if (this.m_9236_().m_46859_(pos)) {
                    this.m_9236_().m_46597_(pos, BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)pos));
                }
            }
        }
        this.m_146870_();
    }

    protected void m_6532_(HitResult hitresult) {
        super.m_6532_(hitresult);
        if (!this.m_9236_().f_46443_) {
            float radius = this.getExplosionRadius();
            float radiusSqr = radius * radius;
            List entities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_((double)radius));
            Vec3 losPoint = Utils.raycastForBlock((Level)this.m_9236_(), (Vec3)this.m_20182_(), (Vec3)this.m_20182_().m_82520_(0.0, 2.0, 0.0), (ClipContext.Fluid)ClipContext.Fluid.NONE).m_82450_();
            for (Entity entity : entities) {
                double distanceToSqr = entity.m_20238_(hitresult.m_82450_());
                if (!(distanceToSqr < (double)radiusSqr) || !this.m_5603_(entity) || !Utils.hasLineOfSight((Level)this.m_9236_(), (Vec3)losPoint, (Vec3)entity.m_20191_().m_82399_(), (boolean)true)) continue;
                double modifier = 1.0 - distanceToSqr / (double)radiusSqr;
                float damage = (float)((double)this.getDamage() * modifier);
                ScreenShake_Entity.ScreenShake((Level)this.m_9236_(), (Vec3)entity.m_20182_(), (float)5.0f, (float)0.15f, (int)20, (int)20);
                DamageSources.applyDamage((Entity)entity, (float)damage, (DamageSource)((AbstractSpell)SpellRegistries.PARTING_SHOT.get()).getDamageSource((Entity)this, this.m_19749_()));
            }
            if (((Boolean)CSConfig.doSpellGriefing.get()).booleanValue()) {
                Explosion explosion = new Explosion(this.m_9236_(), null, (DamageSource)((AbstractSpell)SpellRegistries.PARTING_SHOT.get()).getDamageSource((Entity)this, this.m_19749_()), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getExplosionRadius() / 2.0f, true, Explosion.BlockInteraction.DESTROY);
                if (!ForgeEventFactory.onExplosionStart((Level)this.m_9236_(), (Explosion)explosion)) {
                    explosion.m_46061_();
                    explosion.m_46075_(false);
                }
            }
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.FIRE.get()).getTargetingColor(), this.getExplosionRadius() * 2.0f), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)false);
            if (hitresult instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)hitresult;
                this.m_5790_(entityHitResult);
            }
            this.createAoEField(hitresult.m_82450_());
            this.m_146870_();
        }
    }

    public void createAoEField(Vec3 location) {
        if (!this.m_9236_().f_46443_) {
            NoManZoneAoE aoE = new NoManZoneAoE(this.m_9236_());
            aoE.m_5602_(this.m_19749_());
            aoE.setDuration(200);
            aoE.setDamage(5.5f);
            aoE.setRadius(6.0f);
            aoE.setCircular();
            aoE.m_20219_(location);
            this.m_9236_().m_7967_((Entity)aoE);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

