/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.entity.spells.infernal_blade;

import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.github.L_Ender.cataclysm.init.ModSounds;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.Optional;
import java.util.function.Supplier;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSEntityRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.SpellRegistries;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class InfernalBladeProjectile
extends AbstractMagicProjectile
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> SOUL = SynchedEntityData.m_135353_(InfernalBladeProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimationController<InfernalBladeProjectile> animationController = new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate);

    public InfernalBladeProjectile(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_20242_(true);
    }

    public InfernalBladeProjectile(Level level, LivingEntity shooter) {
        this((EntityType<? extends Projectile>)((EntityType)CSEntityRegistry.INFERNAL_BLADE_PROJECTILE.get()), level);
        this.m_5602_((Entity)shooter);
    }

    public void travel() {
        this.m_146884_(this.m_20182_().m_82549_(this.m_20184_()));
        if (!this.m_20068_()) {
            Vec3 vec3 = this.m_20184_();
            this.m_20334_(vec3.f_82479_, vec3.f_82480_ - (double)0.05f, vec3.f_82481_);
        }
    }

    public void m_8119_() {
        Vec3 deltaMovement = this.m_20184_();
        double distance = deltaMovement.m_165924_();
        double x = deltaMovement.f_82479_;
        double y = deltaMovement.f_82480_;
        double z = deltaMovement.f_82481_;
        this.m_146922_((float)(Mth.m_14136_((double)x, (double)z) * 57.29577951308232));
        this.m_146926_((float)(Mth.m_14136_((double)y, (double)distance) * 57.29577951308232));
        this.m_146926_(InfernalBladeProjectile.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
        this.m_146922_(InfernalBladeProjectile.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
        super.m_8119_();
    }

    public void trailParticles() {
        Vec3 vec3 = this.m_20182_().m_82546_(this.m_20184_());
        this.m_9236_().m_7106_(ParticleHelper.EMBERS, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.0, 0.0, 0.0);
    }

    public void impactParticles(double x, double y, double z) {
        MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)((ParticleOptions)ModParticle.TRAP_FLAME.get()), (double)x, (double)y, (double)z, (int)5, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (boolean)true);
    }

    public float getSpeed() {
        return 0.7f;
    }

    public Optional<Supplier<SoundEvent>> getImpactSound() {
        return Optional.of(ModSounds.IGNIS_POKE);
    }

    protected void doImpactSound(Supplier<SoundEvent> sound) {
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), sound.get(), SoundSource.NEUTRAL, 1.5f, 0.5f);
    }

    protected void m_5790_(EntityHitResult pResult) {
        Entity target = pResult.m_82443_();
        DamageSources.applyDamage((Entity)target, (float)this.damage, (DamageSource)((AbstractSpell)SpellRegistries.INFERNAL_STRIKE.get()).getDamageSource((Entity)this, this.m_19749_()));
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            livingTarget.m_7292_(new MobEffectInstance((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get(), 100, 0));
        }
        this.m_146870_();
    }

    protected void m_8060_(BlockHitResult pResult) {
        super.m_8060_(pResult);
        this.m_146870_();
    }

    public boolean getIsSoul() {
        return (Boolean)this.f_19804_.m_135370_(SOUL);
    }

    public void setIsSoul(boolean soul) {
        this.f_19804_.m_135381_(SOUL, (Object)soul);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{this.animationController});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    private PlayState predicate(AnimationState<InfernalBladeProjectile> event) {
        event.getController().setAnimation(RawAnimation.begin().then("animation.infernal_blade_small.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SOUL, (Object)false);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setIsSoul(pCompound.m_128471_("Soul"));
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("Soul", this.getIsSoul());
    }
}

