/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.onlyhammersandexcavators.mixin;

import com.blocklegend001.onlyhammersandexcavators.item.custom.Hammer;
import com.blocklegend001.onlyhammersandexcavators.utils.RadiusMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class LevelRendererHammerMixin {
    @Inject(method={"renderLevel"}, at={@At(value="TAIL")})
    private void renderLevelAfter(PoseStack poseStack, float partialTicks, long p_109602_, boolean p_109603_, Camera camera, GameRenderer p_109605_, LightTexture p_109606_, Matrix4f projection, CallbackInfo ci) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        ItemStack held = mc.f_91074_.m_21205_();
        if (!(held.m_41720_() instanceof Hammer)) {
            return;
        }
        HitResult hitResult = mc.f_91077_;
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult hit = (BlockHitResult)hitResult;
        BlockPos origin = hit.m_82425_();
        if (!mc.f_91073_.m_8055_(origin).m_204336_(BlockTags.f_144282_)) {
            return;
        }
        int range = mc.f_91074_.m_6144_() ? 0 : RadiusMap.getHammerRadius().get(held.m_41720_());
        AABB box = LevelRendererHammerMixin.getSelectionBox(range, hit.m_82434_(), origin);
        Vec3 cam = camera.m_90583_();
        AABB shifted = box.m_82386_(-cam.f_82479_, -cam.f_82480_, -cam.f_82481_);
        poseStack.m_85836_();
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix = pose.m_252922_();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.lineWidth((float)2.0f);
        VertexConsumer lines = mc.m_91269_().m_110104_().m_6299_((RenderType)RenderType.f_110371_);
        LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)lines, (AABB)shifted, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.m_91269_().m_110104_().m_109912_((RenderType)RenderType.f_110371_);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        poseStack.m_85849_();
    }

    private static AABB getSelectionBox(int range, Direction side, BlockPos origin) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                BlockPos pos = switch (side.m_122434_()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Direction.Axis.Y -> origin.m_7918_(x, 0, y);
                    case Direction.Axis.X -> origin.m_7918_(0, y, x);
                    case Direction.Axis.Z -> origin.m_7918_(x, y, 0);
                };
                minX = Math.min(minX, pos.m_123341_());
                minY = Math.min(minY, pos.m_123342_());
                minZ = Math.min(minZ, pos.m_123343_());
                maxX = Math.max(maxX, pos.m_123341_() + 1);
                maxY = Math.max(maxY, pos.m_123342_() + 1);
                maxZ = Math.max(maxZ, pos.m_123343_() + 1);
            }
        }
        return new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }
}

