/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.onlyhammersandexcavators.item.custom;

import com.blocklegend001.onlyhammersandexcavators.utils.RadiusMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class Hammer
extends DiggerItem {
    public Hammer(Tier pTier, float pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pAttackDamageModifier, pAttackSpeedModifier, pTier, BlockTags.f_144282_, pProperties);
    }

    public static List<BlockPos> getBlocksToBeDestroyed(int range, BlockPos initalBlockPos, ServerPlayer player) {
        int y;
        int x;
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        BlockHitResult traceResult = player.m_9236_().m_45547_(new ClipContext(player.m_20299_(1.0f), player.m_20299_(1.0f).m_82549_(player.m_20252_(1.0f).m_82490_(6.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        if (traceResult.m_6662_() == HitResult.Type.MISS) {
            return positions;
        }
        if (traceResult.m_82434_() == Direction.DOWN || traceResult.m_82434_() == Direction.UP) {
            for (x = -range; x <= range; ++x) {
                for (y = -range; y <= range; ++y) {
                    positions.add(new BlockPos(initalBlockPos.m_123341_() + x, initalBlockPos.m_123342_(), initalBlockPos.m_123343_() + y));
                }
            }
        }
        if (traceResult.m_82434_() == Direction.NORTH || traceResult.m_82434_() == Direction.SOUTH) {
            for (x = -range; x <= range; ++x) {
                for (y = -range; y <= range; ++y) {
                    positions.add(new BlockPos(initalBlockPos.m_123341_() + x, initalBlockPos.m_123342_() + y, initalBlockPos.m_123343_()));
                }
            }
        }
        if (traceResult.m_82434_() == Direction.EAST || traceResult.m_82434_() == Direction.WEST) {
            for (x = -range; x <= range; ++x) {
                for (y = -range; y <= range; ++y) {
                    positions.add(new BlockPos(initalBlockPos.m_123341_(), initalBlockPos.m_123342_() + y, initalBlockPos.m_123343_() + x));
                }
            }
        }
        return positions;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag type) {
        int radius = this.getRadiusForHammer(stack);
        int widht = radius * 2 + 1;
        MutableComponent text = Component.m_237113_((String)"Dig area: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(widht + "x1")).m_130940_(ChatFormatting.YELLOW));
        tooltip.add((Component)text);
        super.m_7373_(stack, level, tooltip, type);
    }

    private int getRadiusForHammer(ItemStack stack) {
        if (RadiusMap.getHammerRadius().containsKey(stack.m_41720_())) {
            return RadiusMap.getHammerRadius().get(stack.m_41720_());
        }
        return 0;
    }
}

