/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items;

import com.google.common.collect.Multimap;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.advancements.ActionTypeTrigger;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.client.renderer.BackpackItemStackRenderer;
import com.tiviacz.travelersbackpack.client.screens.tooltip.BackpackTooltipComponent;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.common.recipes.BackpackDyeRecipe;
import com.tiviacz.travelersbackpack.compat.curios.TravelersBackpackCurio;
import com.tiviacz.travelersbackpack.config.BackpackEffect;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.entity.BackpackItemEntity;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.BackpackContainer;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.FluidTankItemWrapper;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import com.tiviacz.travelersbackpack.util.KeyHelper;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import com.tiviacz.travelersbackpack.util.TextUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TravelersBackpackItem
extends BlockItem {
    public static final DecimalFormat ATTRIBUTE_MODIFIER_FORMAT = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat("#.##"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    @Deprecated(forRemoval=true)
    public final ResourceLocation texture;
    public static CauldronInteraction DYED_BACKPACK = (state, level, pos, player, hand, stack) -> {
        Item item = stack.m_41720_();
        if (!(item instanceof TravelersBackpackItem)) {
            return InteractionResult.PASS;
        }
        if (!BackpackDyeRecipe.hasColor(stack)) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            stack.m_41783_().m_128473_("Color");
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ActionTypeTrigger.INSTANCE.trigger(serverPlayer, "undye_backpack");
            }
            LayeredCauldronBlock.m_153559_((BlockState)state, (Level)level, (BlockPos)pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    };

    public TravelersBackpackItem(Block block) {
        this(block, "");
    }

    @Deprecated(forRemoval=true)
    public TravelersBackpackItem(Block block, String name) {
        this(block, new ResourceLocation("travelersbackpack", "textures/model/" + name.toLowerCase(Locale.ENGLISH) + ".png"));
    }

    @Deprecated(forRemoval=true)
    public TravelersBackpackItem(Block block, ResourceLocation texture) {
        super(block, new Item.Properties().m_41487_(1));
        this.texture = texture;
    }

    @Deprecated(forRemoval=true)
    public ResourceLocation getBackpackTexture() {
        return this.texture;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (hand == InteractionHand.OFF_HAND || player.m_6047_()) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        if (!((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.allowOnlyEquippedBackpack.get()).booleanValue()) {
            if (!level.f_46443_) {
                BackpackContainer.openBackpack((ServerPlayer)player, player.m_150109_().m_36056_(), 1, player.m_150109_().f_35977_);
            }
        } else if (!CapabilityUtils.isWearingBackpack(player) && !TravelersBackpack.enableIntegration()) {
            ServerActions.equipBackpack(player);
            player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.f_46443_);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult interactionResult = this.m_40576_(new BlockPlaceContext(context));
        return !interactionResult.m_19077_() ? this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_() : interactionResult;
    }

    public InteractionResult m_40576_(BlockPlaceContext context) {
        if (!context.m_7059_() || context.m_43724_() == InteractionHand.MAIN_HAND && context.m_43723_() != null && !context.m_43723_().m_6047_()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockitemusecontext = this.m_7732_(context);
        if (blockitemusecontext == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockstate = this.m_5965_(blockitemusecontext);
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        if (!this.m_7429_(blockitemusecontext, blockstate)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = blockitemusecontext.m_8083_();
        Level level = blockitemusecontext.m_43725_();
        Player player = blockitemusecontext.m_43723_();
        ItemStack itemstack = blockitemusecontext.m_43722_();
        BlockState blockstate1 = level.m_8055_(blockpos);
        if (blockstate1.m_60713_(blockstate.m_60734_())) {
            this.m_7274_(blockpos, level, player, itemstack, blockstate1);
            blockstate1.m_60734_().m_6402_(level, blockpos, blockstate1, (LivingEntity)player, itemstack);
            BlockEntity blockEntity = level.m_7702_(blockpos);
            if (blockEntity instanceof BackpackBlockEntity) {
                BackpackBlockEntity blockEntity2 = (BackpackBlockEntity)blockEntity;
                blockEntity2.setBackpack(itemstack);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10591_.m_285767_(serverPlayer, blockpos, itemstack);
            }
        }
        level.m_142346_((Entity)player, GameEvent.f_157797_, blockpos);
        SoundType soundtype = blockstate1.getSoundType((LevelReader)level, blockpos, (Entity)context.m_43723_());
        level.m_5594_(player, blockpos, this.getPlaceSound(blockstate1, level, blockpos, player), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        if (player == null || !player.m_150110_().f_35937_) {
            itemstack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    protected boolean m_7274_(BlockPos pPos, Level pLevel, @Nullable Player pPlayer, ItemStack pStack, BlockState pState) {
        return TravelersBackpackItem.m_40582_(pLevel, pPlayer, pPos, pStack);
    }

    public static boolean m_40582_(Level pLevel, @Nullable Player pPlayer, BlockPos pPos, ItemStack pStack) {
        MinecraftServer minecraftserver = pLevel.m_7654_();
        if (minecraftserver == null) {
            return false;
        }
        if (pStack.m_41783_() == null) {
            return false;
        }
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity != null && blockEntity instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpackBlockEntity = (BackpackBlockEntity)blockEntity;
            if (pLevel.f_46443_ || !blockEntity.m_6326_() || pPlayer != null && pPlayer.m_36337_()) {
                if (pStack.m_41788_()) {
                    backpackBlockEntity.setCustomName(pStack.m_41786_());
                }
                blockEntity.m_6596_();
                return true;
            }
        }
        return false;
    }

    public static boolean isCreative(Player player) {
        return player.m_9236_().m_5776_() && player.f_36096_ instanceof CreativeModeInventoryScreen.ItemPickerMenu;
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (TravelersBackpackItem.isCreative(player) || stack.m_41613_() > 1 || !slot.m_8010_(player) || action != ClickAction.SECONDARY) {
            return super.m_142207_(stack, slot, action, player);
        }
        ItemStack itemstack = slot.m_7993_();
        if (BackpackSlotItemHandler.isItemValid(itemstack)) {
            int count = TravelersBackpackItem.add(player, stack, itemstack, true);
            if (count <= 0) {
                return false;
            }
            int j = TravelersBackpackItem.add(player, stack, slot.m_150647_(count, count, player), false);
            if (j > 0) {
                this.playInsertSound((Entity)player);
            }
            return true;
        }
        return super.m_142207_(stack, slot, action, player);
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (TravelersBackpackItem.isCreative(player) || stack.m_41613_() > 1 || !slot.m_5857_(stack) || action != ClickAction.SECONDARY) {
            return super.m_142305_(stack, other, slot, action, player, access);
        }
        if (slot.m_150651_(player)) {
            int i = TravelersBackpackItem.add(player, stack, other, false);
            if (i > 0) {
                this.playInsertSound((Entity)player);
                other.m_41774_(i);
            }
            return true;
        }
        return super.m_142305_(stack, other, slot, action, player, access);
    }

    private static int add(Player player, ItemStack backpackStack, ItemStack insertedStack, boolean simulate) {
        int k = insertedStack.m_41613_();
        if (!insertedStack.m_41619_() && BackpackSlotItemHandler.isItemValid(insertedStack)) {
            LazyOptional itemHandler = backpackStack.getCapability(ForgeCapabilities.ITEM_HANDLER);
            AtomicInteger count = new AtomicInteger(0);
            itemHandler.ifPresent(handler -> {
                ItemStack result = InventoryHelper.addItemStackToHandler(handler, insertedStack, simulate);
                count.set(k - result.m_41613_());
            });
            return count.get();
        }
        return 0;
    }

    private void playInsertSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, context, tooltipComponents, tooltipFlag);
        if (NbtHelper.has(stack, "Tier")) {
            tooltipComponents.add((Component)Component.m_237115_((String)("tier.travelersbackpack." + Tiers.of((Integer)NbtHelper.get(stack, "Tier")).getName())));
        }
        if (NbtHelper.has(stack, "Inventory") && !KeyHelper.isCtrlPressed()) {
            tooltipComponents.add((Component)Component.m_237115_((String)"item.travelersbackpack.inventory_tooltip").m_130940_(ChatFormatting.BLUE));
        }
        if (((Boolean)TravelersBackpackConfig.CLIENT.obtainTips.get()).booleanValue()) {
            if (stack.m_41720_() == ModItems.BAT_TRAVELERS_BACKPACK.get()) {
                tooltipComponents.add((Component)Component.m_237115_((String)"obtain.travelersbackpack.bat").m_130940_(ChatFormatting.BLUE));
            }
            if (stack.m_41720_() == ModItems.VILLAGER_TRAVELERS_BACKPACK.get()) {
                tooltipComponents.add((Component)Component.m_237115_((String)"obtain.travelersbackpack.villager").m_130940_(ChatFormatting.BLUE));
            }
            if (stack.m_41720_() == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK.get()) {
                tooltipComponents.add((Component)Component.m_237115_((String)"obtain.travelersbackpack.iron_golem").m_130940_(ChatFormatting.BLUE));
            }
        }
        if (BackpackAbilities.ALLOWED_ABILITIES.contains(stack.m_41720_()) && ((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue()) {
            if (KeyHelper.isShiftPressed()) {
                if (BackpackAbilities.CUSTOM_DESCRIPTIONS.contains(stack.m_41720_())) {
                    tooltipComponents.add((Component)Component.m_237115_((String)("ability.travelersbackpack." + this.m_5671_(stack).replaceAll("block.travelersbackpack.", ""))).m_130940_(ChatFormatting.BLUE));
                }
                boolean whenEquippedPresent = false;
                if (BackpackAbilities.getBackpackEffects().containsKey((Object)stack.m_41720_())) {
                    tooltipComponents.add((Component)Component.m_237115_((String)"ability.travelersbackpack.when_equipped").m_130940_(ChatFormatting.DARK_PURPLE));
                    whenEquippedPresent = true;
                    BackpackAbilities.getBackpackEffects().entries().stream().filter(entry -> entry.getKey() == stack.m_41720_()).forEach(entry -> {
                        MutableComponent mutablecomponent = Component.m_237113_((String)"- ");
                        mutablecomponent.m_7220_((Component)Component.m_237115_((String)((BackpackEffect)entry.getValue()).effect().m_19481_()));
                        MobEffect mobeffect = ((BackpackEffect)entry.getValue()).effect();
                        if (((BackpackEffect)entry.getValue()).amplifier() > 0) {
                            mutablecomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.m_237115_((String)("potion.potency." + ((BackpackEffect)entry.getValue()).amplifier()))});
                        }
                        if (BackpackAbilities.getCooldowns().containsKey(stack.m_41720_())) {
                            mutablecomponent.m_130946_(" " + TextUtils.getConvertedTime(((BackpackEffect)entry.getValue()).minDuration()));
                        }
                        tooltipComponents.add((Component)mutablecomponent.m_130940_(mobeffect.m_19483_().m_19497_()));
                    });
                }
                this.addAttributeModifierTooltip(stack, tooltipComponents, whenEquippedPresent);
                if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, stack) && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, stack)) {
                    tooltipComponents.add((Component)Component.m_237115_((String)"ability.travelersbackpack.item_and_block"));
                } else if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, stack) && !BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, stack)) {
                    tooltipComponents.add((Component)Component.m_237115_((String)"ability.travelersbackpack.block"));
                } else if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, stack) && !BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, stack)) {
                    tooltipComponents.add((Component)Component.m_237115_((String)"ability.travelersbackpack.item"));
                }
            } else {
                tooltipComponents.add((Component)Component.m_237115_((String)"ability.travelersbackpack.hold_shift").m_130940_(ChatFormatting.BLUE));
            }
        }
    }

    public void addAttributeModifierTooltip(ItemStack stack, List<Component> tooltipComponents, boolean whenEquippedPresent) {
        Multimap<Attribute, AttributeModifier> multimap = BackpackAbilities.ABILITIES.getAttributeAbilityMultimap(stack);
        if (!multimap.isEmpty()) {
            if (!whenEquippedPresent) {
                tooltipComponents.add((Component)Component.m_237115_((String)"ability.travelersbackpack.when_equipped").m_130940_(ChatFormatting.DARK_PURPLE));
            }
            for (Map.Entry entry : multimap.entries()) {
                AttributeModifier attributeModifier = (AttributeModifier)entry.getValue();
                double d = attributeModifier.m_22218_();
                boolean bl = false;
                double e = attributeModifier.m_22217_() == AttributeModifier.Operation.MULTIPLY_BASE || attributeModifier.m_22217_() == AttributeModifier.Operation.MULTIPLY_TOTAL ? d * 100.0 : (((Attribute)entry.getKey()).equals(Attributes.f_22278_) ? d * 10.0 : d);
                if (bl) {
                    tooltipComponents.add((Component)CommonComponents.m_264333_().m_7220_((Component)Component.m_237110_((String)("attribute.modifier.equals." + attributeModifier.m_22217_().m_22235_()), (Object[])new Object[]{ATTRIBUTE_MODIFIER_FORMAT.format(e), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())})).m_130940_(ChatFormatting.DARK_GREEN));
                    continue;
                }
                if (d > 0.0) {
                    tooltipComponents.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + attributeModifier.m_22217_().m_22235_()), (Object[])new Object[]{ATTRIBUTE_MODIFIER_FORMAT.format(e), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d < 0.0)) continue;
                tooltipComponents.add((Component)Component.m_237110_((String)("attribute.modifier.take." + attributeModifier.m_22217_().m_22235_()), (Object[])new Object[]{ATTRIBUTE_MODIFIER_FORMAT.format(e *= -1.0), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return this.hasCustomData(stack);
    }

    @Nullable
    public Entity createEntity(Level level, Entity entity, ItemStack itemstack) {
        if (!(entity instanceof ItemEntity)) {
            return null;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        return this.createBackpackEntity(level, itemEntity, itemstack);
    }

    public boolean hasCustomData(ItemStack stack) {
        if (NbtHelper.getOrDefault(stack, "Inventory", NonNullList.m_122780_((int)0, (Object)ItemStack.f_41583_)).stream().anyMatch(itemStack -> !itemStack.m_41619_())) {
            return true;
        }
        NonNullList upgrades = NbtHelper.getOrDefault(stack, "Upgrades", NonNullList.m_122780_((int)0, (Object)ItemStack.f_41583_));
        if (upgrades.stream().anyMatch(itemStack -> !itemStack.m_41619_() && !itemStack.m_150930_((Item)ModItems.TANKS_UPGRADE.get())) && upgrades.stream().anyMatch(itemStack -> itemStack.m_150930_((Item)ModItems.TANKS_UPGRADE.get()))) {
            return true;
        }
        if (NbtHelper.getOrDefault(stack, "ToolsInventory", NonNullList.m_122780_((int)0, (Object)ItemStack.f_41583_)).stream().anyMatch(itemStack -> !itemStack.m_41619_())) {
            return true;
        }
        return NbtHelper.getOrDefault(stack, "Tier", 0) >= Tiers.DIAMOND.getOrdinal();
    }

    @Nullable
    private BackpackItemEntity createBackpackEntity(Level level, ItemEntity itemEntity, ItemStack itemstack) {
        BackpackItemEntity backpackItemEntity = (BackpackItemEntity)ModItems.BACKPACK_ITEM_ENTITY.get().m_20615_(level);
        if (backpackItemEntity != null) {
            backpackItemEntity.m_6034_(itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_());
            backpackItemEntity.m_32045_(itemstack.m_41777_());
            backpackItemEntity.m_32010_(itemEntity.f_31986_);
            if (itemEntity.m_19749_() != null) {
                backpackItemEntity.m_32052_(itemEntity.m_19749_().m_20148_());
            }
            backpackItemEntity.m_20256_(itemEntity.m_20184_());
        }
        return backpackItemEntity;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        return Optional.of(new BackpackTooltipComponent(stack));
    }

    public boolean m_142095_() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        final Supplier<BlockEntityWithoutLevelRenderer> renderer = () -> new BackpackItemStackRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)renderer.get();
            }
        });
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                BackpackWrapper wrapper;
                if (cap == ForgeCapabilities.ITEM_HANDLER) {
                    BackpackWrapper wrapper2 = BackpackWrapper.fromStack(stack);
                    return LazyOptional.of(wrapper2::getStorageForInputOutput).cast();
                }
                if (cap == ForgeCapabilities.FLUID_HANDLER_ITEM && (wrapper = BackpackWrapper.fromStack(stack)).getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
                    FluidTankItemWrapper fluidItemWrapper = new FluidTankItemWrapper(stack, wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).get());
                    return LazyOptional.of(() -> fluidItemWrapper).cast();
                }
                if (TravelersBackpack.enableCurios()) {
                    return TravelersBackpackCurio.getCurioCapability(cap, stack);
                }
                return LazyOptional.empty();
            }
        };
    }

    public static void registerCauldronInteraction() {
        CauldronInteraction.f_175607_.put((Item)ModItems.STANDARD_TRAVELERS_BACKPACK.get(), DYED_BACKPACK);
    }
}

