/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.jukebox;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetElement;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.jukebox.JukeboxUpgrade;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class JukeboxWidget
extends UpgradeWidgetBase<JukeboxUpgrade> {
    private final WidgetElement playButton = new WidgetElement(new Point(24, 22), new Point(18, 18));
    private final WidgetElement stopButton = new WidgetElement(new Point(42, 22), new Point(18, 18));

    public JukeboxWidget(BackpackScreen screen, JukeboxUpgrade upgrade, Point pos) {
        super(screen, upgrade, pos, new Point(137, 103), "screen.travelersbackpack.jukebox_upgrade");
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.isTabOpened()) {
            if (this.isMouseOverPlayButton(mouseX, mouseY)) {
                guiGraphics.m_280218_(BackpackScreen.ICONS, this.pos.x() + this.playButton.pos().x(), this.pos.y() + this.playButton.pos().y(), 24, 18, this.playButton.size().x(), this.playButton.size().y());
            }
            if (this.isMouseOverStopButton(mouseX, mouseY)) {
                guiGraphics.m_280218_(BackpackScreen.ICONS, this.pos.x() + this.stopButton.pos().x(), this.pos.y() + this.stopButton.pos().y(), 24, 18, this.stopButton.size().x(), this.stopButton.size().y());
            }
        }
    }

    @Override
    public void renderBg(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, x, y, mouseX, mouseY);
        if (this.isTabOpened() && ((JukeboxUpgrade)this.upgrade).isPlayingRecord()) {
            guiGraphics.m_280218_(BackpackScreen.ICONS, this.pos.x() + 6, this.pos.y() + 22, 24, 36, 18, 18);
        }
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (((JukeboxUpgrade)this.upgrade).getUpgradeManager().getWrapper().getScreenID() == 2 && this.isMouseOverPlayButton(pMouseX, pMouseY) && this.isBackpackOwner() && this.isTabOpened() && ((JukeboxUpgrade)this.upgrade).canPlayRecord()) {
            ServerboundActionTagPacket.create(0, this.dataHolderSlot, true, 3);
            this.playDiscToPlayer(((BackpackBaseMenu)((BackpackScreen)this.screen).m_6262_()).getPlayerInventory().f_35978_.m_19879_(), this.getFromDisk(((JukeboxUpgrade)this.upgrade).diskHandler.getStackInSlot(0)), this.getDescription(((JukeboxUpgrade)this.upgrade).diskHandler.getStackInSlot(0)));
            ((BackpackScreen)this.screen).playUIClickSound();
            return true;
        }
        if (this.isMouseOverStopButton(pMouseX, pMouseY) && this.isBackpackOwner() && this.isTabOpened() && ((JukeboxUpgrade)this.upgrade).isPlayingRecord()) {
            ServerboundActionTagPacket.create(0, this.dataHolderSlot, false, 3);
            if (((JukeboxUpgrade)this.upgrade).getUpgradeManager().getWrapper().getScreenID() == 2) {
                this.stopDisc(this.getFromDisk(((JukeboxUpgrade)this.upgrade).diskHandler.getStackInSlot(0)));
            }
            ((BackpackScreen)this.screen).playUIClickSound();
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean isMouseOverPlayButton(double mouseX, double mouseY) {
        return this.isWithinBounds(mouseX, mouseY, this.playButton);
    }

    public boolean isMouseOverStopButton(double mouseX, double mouseY) {
        return this.isWithinBounds(mouseX, mouseY, this.stopButton);
    }

    @Nullable
    public SoundEvent getFromDisk(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof RecordItem) {
            RecordItem record = (RecordItem)item;
            return record.m_43051_();
        }
        return null;
    }

    @Nullable
    public Component getDescription(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof RecordItem) {
            RecordItem record = (RecordItem)item;
            return record.m_43050_();
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playDiscToPlayer(int entityId, @Nullable SoundEvent jukeboxSong, @Nullable Component description) {
        if (jukeboxSong == null) {
            return;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(entityId);
        if (entity == null) {
            return;
        }
        Minecraft.m_91087_().m_91106_().m_120372_((TickableSoundInstance)new MovingSound(entity, jukeboxSong));
        if (description != null) {
            Minecraft.m_91087_().f_91065_.m_93055_(description);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void stopDisc(SoundEvent jukeboxSong) {
        if (jukeboxSong == null) {
            return;
        }
        Minecraft.m_91087_().m_91106_().m_120386_(jukeboxSong.m_11660_(), SoundSource.NEUTRAL);
    }

    public static class MovingSound
    extends AbstractTickableSoundInstance {
        private final Entity entity;

        public MovingSound(Entity entityIn, SoundEvent soundIn) {
            super(soundIn, SoundSource.NEUTRAL, entityIn.m_9236_().m_213780_());
            this.entity = entityIn;
            this.f_119578_ = false;
            this.f_119579_ = 0;
            this.f_119573_ = 1.0f;
        }

        public void m_7788_() {
            Player player;
            Entity entity = this.entity;
            if (!(!(entity instanceof Player) || CapabilityUtils.isWearingBackpack(player = (Player)entity) && this.shouldStopPlaying(player))) {
                this.m_119609_();
            }
            if (!this.entity.m_6084_()) {
                this.m_119609_();
            } else {
                this.f_119575_ = (float)this.entity.m_20185_();
                this.f_119576_ = (float)this.entity.m_20186_();
                this.f_119577_ = (float)this.entity.m_20189_();
            }
        }

        public boolean shouldStopPlaying(Player player) {
            return CapabilityUtils.getBackpackWrapper(player, CapabilityUtils.UPGRADES_ONLY).getUpgradeManager().getUpgrade(JukeboxUpgrade.class).isPresent();
        }
    }
}

