/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.jukebox;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.UpgradeSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.jukebox.JukeboxWidget;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class JukeboxUpgrade
extends UpgradeBase<JukeboxUpgrade> {
    public ItemStackHandler diskHandler;

    public JukeboxUpgrade(UpgradeManager manager, int dataHolderSlot, NonNullList<ItemStack> musicDiskContents) {
        super(manager, dataHolderSlot, new Point(66, 46));
        this.diskHandler = this.createHandler(musicDiskContents);
    }

    @Override
    public void onUpgradeRemoved(ItemStack removedStack) {
        NbtHelper.set(removedStack, "IsPlaying", false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new JukeboxWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    public List<Pair<Integer, Integer>> getUpgradeSlotsPosition(int x, int y) {
        ArrayList<Pair<Integer, Integer>> positions = new ArrayList<Pair<Integer, Integer>>();
        positions.add(Pair.of((Object)(x + 7), (Object)(y + 23)));
        return positions;
    }

    @Override
    public List<Slot> getUpgradeSlots(BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        slots.add((Slot)new UpgradeSlotItemHandler<JukeboxUpgrade>(this, (IItemHandler)this.diskHandler, 0, x + 7, y + 23){

            public boolean m_5857_(ItemStack pStack) {
                return JukeboxUpgrade.this.isTabOpened() && NbtHelper.getOrDefault(JukeboxUpgrade.this.getDataHolderStack(), "IsPlaying", false) == false;
            }

            public boolean m_8010_(Player playerIn) {
                return super.m_8010_(playerIn) && NbtHelper.getOrDefault(JukeboxUpgrade.this.getDataHolderStack(), "IsPlaying", false) == false;
            }
        });
        return slots;
    }

    public boolean isPlayingRecord() {
        return NbtHelper.getOrDefault(this.getDataHolderStack(), "IsPlaying", false);
    }

    public boolean canPlayRecord() {
        return !this.isPlayingRecord() && !this.diskHandler.getStackInSlot(0).m_41619_();
    }

    public void setSlotChanged(ItemStack dataHolderStack, int index, ItemStack stack) {
        NbtHelper.update(dataHolderStack, "Inventory", 1, index, stack);
    }

    private ItemStackHandler createHandler(NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            protected void onContentsChanged(int slot) {
                JukeboxUpgrade.this.updateDataHolderUnchecked(dataHolderStack -> JukeboxUpgrade.this.setSlotChanged((ItemStack)dataHolderStack, slot, this.getStackInSlot(slot)));
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.m_41720_() instanceof RecordItem;
            }
        };
    }
}

