/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.craftingtweaks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.crafting.CraftingUpgrade;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.blay09.mods.craftingtweaks.api.ButtonAlignment;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.CraftingGridBuilder;
import net.blay09.mods.craftingtweaks.api.CraftingGridProvider;
import net.blay09.mods.craftingtweaks.api.GridBalanceHandler;
import net.blay09.mods.craftingtweaks.api.GridTransferHandler;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BackpackCraftingGridProvider
implements CraftingGridProvider {
    public String getModId() {
        return "travelersbackpack";
    }

    public boolean requiresServerSide() {
        return true;
    }

    public boolean handles(AbstractContainerMenu menu) {
        return menu instanceof BackpackBaseMenu;
    }

    public void buildCraftingGrids(CraftingGridBuilder craftingGridBuilder, AbstractContainerMenu abstractContainerMenu) {
        if (abstractContainerMenu instanceof BackpackBaseMenu) {
            BackpackBaseMenu backpackMenu = (BackpackBaseMenu)abstractContainerMenu;
            craftingGridBuilder.addGrid(backpackMenu.CRAFTING_GRID_START, 9).setButtonAlignment(ButtonAlignment.RIGHT).clearHandler(this::clearGrid).rotateHandler(this::rotateGrid).balanceHandler((GridBalanceHandler)new BackpackBalanceGridHandler()).transferHandler((GridTransferHandler)new BackpackTransferGridHandler()).hideAllTweakButtons();
        }
    }

    public void clearGrid(CraftingGrid grid, Player player, AbstractContainerMenu menu, boolean forced) {
        if (!(menu instanceof BackpackBaseMenu)) {
            return;
        }
        BackpackBaseMenu backpackMenu = (BackpackBaseMenu)menu;
        Optional<CraftingUpgrade> upgrade = backpackMenu.getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class);
        if (upgrade.isEmpty() || !upgrade.get().isTabOpened()) {
            return;
        }
        Container craftMatrix = grid.getCraftingMatrix(player, menu);
        if (craftMatrix != null) {
            int start = grid.getGridStartSlot(player, menu);
            int size = grid.getGridSize(player, menu);
            for (int i = start; i < start + size; ++i) {
                int slotIndex = ((Slot)menu.f_38839_.get(i)).m_150661_();
                ItemStack itemStack = craftMatrix.m_8020_(slotIndex);
                if (itemStack.m_41619_()) continue;
                ItemStack returnStack = itemStack.m_41777_();
                player.m_150109_().m_36054_(returnStack);
                craftMatrix.m_6836_(slotIndex, returnStack.m_41613_() == 0 ? ItemStack.f_41583_ : returnStack);
                if (returnStack.m_41613_() <= 0 || !forced) continue;
                player.m_36176_(returnStack, false);
                craftMatrix.m_6836_(slotIndex, ItemStack.f_41583_);
            }
            menu.m_38946_();
        }
    }

    protected boolean ignoresSlotId(int slotId) {
        return slotId == 4;
    }

    protected int rotateSlotId(int slotId, boolean counterClockwise) {
        block21: {
            block20: {
                if (counterClockwise) break block20;
                switch (slotId) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 5;
                    }
                    case 3: {
                        return 0;
                    }
                    default: {
                        break block21;
                    }
                    case 5: {
                        return 8;
                    }
                    case 6: {
                        return 3;
                    }
                    case 7: {
                        return 6;
                    }
                    case 8: {
                        return 7;
                    }
                }
            }
            switch (slotId) {
                case 0: {
                    return 3;
                }
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 6;
                }
                default: {
                    break;
                }
                case 5: {
                    return 2;
                }
                case 6: {
                    return 7;
                }
                case 7: {
                    return 8;
                }
                case 8: {
                    return 5;
                }
            }
        }
        return 0;
    }

    public void rotateGrid(CraftingGrid grid, Player player, AbstractContainerMenu menu, boolean reverse) {
        if (!(menu instanceof BackpackBaseMenu)) {
            return;
        }
        BackpackBaseMenu backpackMenu = (BackpackBaseMenu)menu;
        Optional<CraftingUpgrade> upgrade = backpackMenu.getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class);
        if (upgrade.isEmpty() || !upgrade.get().isTabOpened()) {
            return;
        }
        Container craftMatrix = grid.getCraftingMatrix(player, menu);
        if (craftMatrix != null) {
            int slotIndex;
            int i;
            int start = grid.getGridStartSlot(player, menu);
            int size = grid.getGridSize(player, menu);
            SimpleContainer matrixClone = new SimpleContainer(size);
            for (i = 0; i < size; ++i) {
                slotIndex = ((Slot)menu.f_38839_.get(start + i)).m_150661_();
                matrixClone.m_6836_(i, craftMatrix.m_8020_(slotIndex));
            }
            for (i = 0; i < size; ++i) {
                if (this.ignoresSlotId(i)) continue;
                slotIndex = ((Slot)menu.f_38839_.get(start + this.rotateSlotId(i, reverse))).m_150661_();
                craftMatrix.m_6836_(slotIndex, matrixClone.m_8020_(i));
            }
            menu.m_38946_();
        }
    }

    public static class BackpackBalanceGridHandler
    implements GridBalanceHandler<AbstractContainerMenu> {
        public void balanceGrid(CraftingGrid grid, Player player, AbstractContainerMenu menu) {
            if (!(menu instanceof BackpackBaseMenu)) {
                return;
            }
            BackpackBaseMenu backpackMenu = (BackpackBaseMenu)menu;
            Optional<CraftingUpgrade> upgrade = backpackMenu.getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class);
            if (upgrade.isEmpty() || !upgrade.get().isTabOpened()) {
                return;
            }
            Container craftMatrix = grid.getCraftingMatrix(player, menu);
            if (craftMatrix != null) {
                ArrayListMultimap itemMap = ArrayListMultimap.create();
                HashMultiset itemCount = HashMultiset.create();
                int start = grid.getGridStartSlot(player, menu);
                int size = grid.getGridSize(player, menu);
                for (int i = start; i < start + size; ++i) {
                    int slotIndex = ((Slot)menu.f_38839_.get(i)).m_150661_();
                    ItemStack itemStack = craftMatrix.m_8020_(slotIndex);
                    if (itemStack.m_41619_() || itemStack.m_41741_() <= 1) continue;
                    ResourceLocation registryName = BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_());
                    Object key = Objects.toString(registryName);
                    if (itemStack.m_41783_() != null) {
                        key = (String)key + "@" + String.valueOf(itemStack.m_41783_());
                    }
                    itemMap.put(key, (Object)slotIndex);
                    itemCount.add(key, itemStack.m_41613_());
                }
                for (String key : itemMap.keySet()) {
                    ItemStack stack;
                    int index;
                    List balanceList = itemMap.get((Object)key);
                    int totalCount = itemCount.count((Object)key);
                    int countPerStack = totalCount / balanceList.size();
                    int restCount = totalCount % balanceList.size();
                    Iterator iterator = balanceList.iterator();
                    while (iterator.hasNext()) {
                        index = (Integer)iterator.next();
                        stack = craftMatrix.m_8020_(index);
                        stack.m_41764_(countPerStack);
                        craftMatrix.m_6836_(index, stack);
                    }
                    int idx = 0;
                    while (restCount > 0) {
                        index = (Integer)balanceList.get(idx);
                        stack = craftMatrix.m_8020_(index);
                        if (stack.m_41613_() < stack.m_41741_()) {
                            ItemStack copy = stack.m_41777_();
                            copy.m_41769_(1);
                            craftMatrix.m_6836_(index, copy);
                            --restCount;
                        }
                        if (++idx < balanceList.size()) continue;
                        idx = 0;
                    }
                }
                menu.m_38946_();
            }
        }

        public void spreadGrid(CraftingGrid grid, Player player, AbstractContainerMenu menu) {
            if (!(menu instanceof BackpackBaseMenu)) {
                return;
            }
            BackpackBaseMenu backpackMenu = (BackpackBaseMenu)menu;
            Optional<CraftingUpgrade> upgrade = backpackMenu.getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class);
            if (upgrade.isEmpty() || !upgrade.get().isTabOpened()) {
                return;
            }
            Container craftMatrix = grid.getCraftingMatrix(player, menu);
            if (craftMatrix != null) {
                boolean emptyBiggestSlot;
                do {
                    ItemStack itemStack;
                    int slotIndex;
                    int i;
                    ItemStack biggestSlotStack = null;
                    int biggestSlotStackSlot = 0;
                    int biggestSlotSize = 1;
                    int start = grid.getGridStartSlot(player, menu);
                    int size = grid.getGridSize(player, menu);
                    for (i = start; i < start + size; ++i) {
                        slotIndex = ((Slot)menu.f_38839_.get(i)).m_150661_();
                        itemStack = craftMatrix.m_8020_(slotIndex);
                        if (itemStack.m_41619_() || itemStack.m_41613_() <= biggestSlotSize) continue;
                        biggestSlotStack = itemStack;
                        biggestSlotStackSlot = slotIndex;
                        biggestSlotSize = itemStack.m_41613_();
                    }
                    if (biggestSlotStack == null) {
                        return;
                    }
                    emptyBiggestSlot = false;
                    for (i = start; i < start + size; ++i) {
                        slotIndex = ((Slot)menu.f_38839_.get(i)).m_150661_();
                        itemStack = craftMatrix.m_8020_(slotIndex);
                        if (!itemStack.m_41619_()) continue;
                        if (biggestSlotStack.m_41613_() > 1) {
                            ItemStack splitted = biggestSlotStack.m_41620_(1);
                            craftMatrix.m_6836_(biggestSlotStackSlot, biggestSlotStack);
                            craftMatrix.m_6836_(slotIndex, splitted);
                            continue;
                        }
                        emptyBiggestSlot = true;
                    }
                } while (emptyBiggestSlot);
                this.balanceGrid(grid, player, menu);
            }
        }
    }

    public static class BackpackTransferGridHandler
    implements GridTransferHandler<AbstractContainerMenu> {
        public ItemStack putIntoGrid(CraftingGrid grid, Player player, AbstractContainerMenu menu, int slotId, ItemStack itemStack) {
            Container craftMatrix = grid.getCraftingMatrix(player, menu);
            if (craftMatrix == null) {
                return itemStack;
            }
            ItemStack craftStack = craftMatrix.m_8020_(slotId).m_41777_();
            if (!craftStack.m_41619_()) {
                int spaceLeft;
                if (ItemStack.m_150942_((ItemStack)craftStack, (ItemStack)itemStack) && (spaceLeft = Math.min(craftMatrix.m_6893_(), craftStack.m_41741_()) - craftStack.m_41613_()) > 0) {
                    ItemStack splitStack = itemStack.m_41620_(Math.min(spaceLeft, itemStack.m_41613_()));
                    craftStack.m_41769_(splitStack.m_41613_());
                    craftMatrix.m_6836_(slotId, craftStack);
                    if (itemStack.m_41613_() <= 0) {
                        return ItemStack.f_41583_;
                    }
                }
            } else {
                ItemStack transferStack = itemStack.m_41620_(Math.min(itemStack.m_41613_(), craftMatrix.m_6893_()));
                craftMatrix.m_6836_(slotId, transferStack);
            }
            return itemStack.m_41613_() <= 0 ? ItemStack.f_41583_ : itemStack;
        }

        public boolean transferIntoGrid(CraftingGrid grid, Player player, AbstractContainerMenu menu, Slot fromSlot) {
            Container craftMatrix = grid.getCraftingMatrix(player, menu);
            if (craftMatrix == null) {
                return false;
            }
            int start = grid.getGridStartSlot(player, menu);
            int size = grid.getGridSize(player, menu);
            ItemStack itemStack = fromSlot.m_7993_();
            if (itemStack.m_41619_()) {
                return false;
            }
            int firstEmptySlot = -1;
            for (int i = start; i < start + size; ++i) {
                int slotIndex = ((Slot)menu.f_38839_.get(i)).m_150661_();
                ItemStack craftStack = craftMatrix.m_8020_(slotIndex).m_41777_();
                if (!craftStack.m_41619_()) {
                    int spaceLeft;
                    if (!ItemStack.m_150942_((ItemStack)craftStack, (ItemStack)itemStack) || (spaceLeft = Math.min(craftMatrix.m_6893_(), craftStack.m_41741_()) - craftStack.m_41613_()) <= 0) continue;
                    ItemStack splitStack = itemStack.m_41620_(Math.min(spaceLeft, itemStack.m_41613_()));
                    craftStack.m_41769_(splitStack.m_41613_());
                    craftMatrix.m_6836_(slotIndex, craftStack);
                    if (itemStack.m_41613_() > 0) continue;
                    return true;
                }
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = slotIndex;
            }
            if (itemStack.m_41613_() > 0 && firstEmptySlot != -1) {
                ItemStack transferStack = itemStack.m_41620_(Math.min(itemStack.m_41613_(), craftMatrix.m_6893_()));
                craftMatrix.m_6836_(firstEmptySlot, transferStack);
                return true;
            }
            return false;
        }

        public boolean canTransferFrom(Player player, AbstractContainerMenu abstractContainerMenu, Slot slot, CraftingGrid craftingGrid) {
            if (abstractContainerMenu instanceof BackpackBaseMenu) {
                BackpackBaseMenu menu = (BackpackBaseMenu)abstractContainerMenu;
                Optional<CraftingUpgrade> upgrade = menu.getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class);
                if (upgrade.isEmpty() || !upgrade.get().isTabOpened()) {
                    return false;
                }
                if (slot.m_8010_(player)) {
                    return slot.f_40218_ == player.m_150109_() || slot.f_40219_ < menu.BACKPACK_INV_END;
                }
            }
            return false;
        }
    }
}

