/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.common;

import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundGhostSlotPacket {
    private final ItemStack stack;
    private final int slotNumber;

    public ServerboundGhostSlotPacket(ItemStack stack, int slotNumber) {
        this.stack = stack;
        this.slotNumber = slotNumber;
    }

    public static ServerboundGhostSlotPacket decode(FriendlyByteBuf buffer) {
        ItemStack stack = buffer.m_130267_();
        int slotNumber = buffer.readInt();
        return new ServerboundGhostSlotPacket(stack, slotNumber);
    }

    public static void encode(ServerboundGhostSlotPacket message, FriendlyByteBuf buffer) {
        buffer.m_130055_(message.stack);
        buffer.writeInt(message.slotNumber);
    }

    public static void handle(ServerboundGhostSlotPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (!(player.f_36096_ instanceof BackpackBaseMenu)) {
                return;
            }
            player.f_36096_.m_38853_(message.slotNumber).m_5852_(message.stack);
        });
        ctx.get().setPacketHandled(true);
    }
}

