/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.bettervillage.compat;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jtorleonstudios.bettervillage.Main;
import com.jtorleonstudios.bettervillage.compat.CompatMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class CompatResourcesListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new Gson();
    public static final List<CompatMetaData> COMPAT_META_DATA_LIST = new ArrayList<CompatMetaData>();

    public CompatResourcesListener() {
        super(GSON, "bettervillage_compat");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> mapResource, @NotNull ResourceManager manager, @NotNull ProfilerFiller profilerFillerIgnored) {
        COMPAT_META_DATA_LIST.clear();
        mapResource.forEach((id, jsonElement) -> {
            try {
                JsonObject result = jsonElement.getAsJsonObject();
                CompatMetaData compat = CompatMetaData.deserialize(id, result);
                compat.debugInformationForEndUser();
                COMPAT_META_DATA_LIST.add(compat);
            }
            catch (Exception e) {
                Main.LOGGER.error("Error occurred while loading resource json " + id.toString(), (Throwable)e);
            }
        });
    }
}

