/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.network;

import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import com.yungnickyoung.minecraft.ribbits.network.ClientPacketHandlerForge;
import com.yungnickyoung.minecraft.ribbits.util.BufferUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class RibbitMusicStartAllS2CPacket {
    private final List<UUID> ribbitIds;
    private final List<ResourceLocation> instrumentIds;
    private final int tickOffset;

    public RibbitMusicStartAllS2CPacket(RibbitEntity masterRibbit, int tickOffset) {
        List ribbitsPlayingMusic = masterRibbit.getRibbitsPlayingMusic().stream().toList();
        ArrayList<UUID> ribbitIds = new ArrayList<UUID>();
        ribbitIds.add(masterRibbit.m_20148_());
        ribbitIds.addAll(ribbitsPlayingMusic.stream().map(Entity::m_20148_).toList());
        ArrayList<ResourceLocation> instrumentIds = new ArrayList<ResourceLocation>();
        instrumentIds.add(masterRibbit.getRibbitData().getInstrument().getId());
        instrumentIds.addAll(ribbitsPlayingMusic.stream().map(ribbit -> ribbit.getRibbitData().getInstrument().getId()).toList());
        this.ribbitIds = ribbitIds;
        this.instrumentIds = instrumentIds;
        this.tickOffset = tickOffset;
    }

    public RibbitMusicStartAllS2CPacket(FriendlyByteBuf buf) {
        this.ribbitIds = BufferUtils.readUUIDList(buf);
        this.instrumentIds = BufferUtils.readResourceLocationList(buf);
        this.tickOffset = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        BufferUtils.writeUUIDList(this.ribbitIds, buf);
        BufferUtils.writeResourceLocationList(this.instrumentIds, buf);
        buf.writeInt(this.tickOffset);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this.lambda$handle$2((Supplier)ctx)));
        ctx.get().setPacketHandled(true);
        return true;
    }

    public List<UUID> getRibbitIds() {
        return this.ribbitIds;
    }

    public List<ResourceLocation> getInstrumentIds() {
        return this.instrumentIds;
    }

    public int getTickOffset() {
        return this.tickOffset;
    }

    private /* synthetic */ Runnable lambda$handle$2(Supplier ctx) {
        return () -> this.lambda$handle$1((Supplier)ctx);
    }

    private /* synthetic */ void lambda$handle$1(Supplier ctx) {
        ClientPacketHandlerForge.handleStartAllRibbitInstruments(this, ctx);
    }
}

