/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.network;

import com.yungnickyoung.minecraft.ribbits.RibbitsCommon;
import com.yungnickyoung.minecraft.ribbits.client.sound.PlayerInstrumentSoundInstance;
import com.yungnickyoung.minecraft.ribbits.client.sound.RibbitInstrumentSoundInstance;
import com.yungnickyoung.minecraft.ribbits.client.supporters.RibbitOptionsJSON;
import com.yungnickyoung.minecraft.ribbits.client.supporters.SupportersListClient;
import com.yungnickyoung.minecraft.ribbits.data.RibbitInstrument;
import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import com.yungnickyoung.minecraft.ribbits.mixin.interfaces.client.ISoundManagerDuck;
import com.yungnickyoung.minecraft.ribbits.mixin.mixins.client.accessor.ClientLevelAccessor;
import com.yungnickyoung.minecraft.ribbits.module.RibbitInstrumentModule;
import com.yungnickyoung.minecraft.ribbits.module.SoundModule;
import com.yungnickyoung.minecraft.ribbits.network.PlayerMusicStartS2CPacket;
import com.yungnickyoung.minecraft.ribbits.network.PlayerMusicStopS2CPacket;
import com.yungnickyoung.minecraft.ribbits.network.RequestSupporterHatStateS2CPacket;
import com.yungnickyoung.minecraft.ribbits.network.RibbitMusicStartAllS2CPacket;
import com.yungnickyoung.minecraft.ribbits.network.RibbitMusicStartSingleS2CPacket;
import com.yungnickyoung.minecraft.ribbits.network.RibbitMusicStopSingleS2CPacket;
import com.yungnickyoung.minecraft.ribbits.network.ToggleSupporterHatS2CPacket;
import com.yungnickyoung.minecraft.ribbits.services.Services;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.network.NetworkEvent;

public class ClientPacketHandlerForge {
    private static final Map<UUID, List<Consumer<Entity>>> pendingEntityActions = new HashMap<UUID, List<Consumer<Entity>>>();

    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        if (!event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        UUID entityId = entity.m_20148_();
        if (pendingEntityActions.containsKey(entityId)) {
            List<Consumer<Entity>> actions = pendingEntityActions.remove(entityId);
            for (Consumer<Entity> action : actions) {
                action.accept(entity);
            }
        }
    }

    public static void onLevelUnload(LevelEvent.Unload event) {
        if (!event.getLevel().m_5776_()) {
            return;
        }
        pendingEntityActions.clear();
    }

    private static void queueOrExecute(UUID entityId, Consumer<Entity> action) {
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        if (clientLevel == null) {
            return;
        }
        Entity entity = (Entity)((ClientLevelAccessor)clientLevel).callGetEntities().m_142694_(entityId);
        if (entity == null) {
            pendingEntityActions.computeIfAbsent(entityId, k -> new ArrayList()).add(action);
        } else {
            action.accept(entity);
        }
    }

    public static void handleStartSingleRibbitInstrument(RibbitMusicStartSingleS2CPacket packet, Supplier<NetworkEvent.Context> ctx) {
        UUID entityId = packet.getRibbitId();
        RibbitInstrument instrument = RibbitInstrumentModule.getInstrument(packet.getInstrumentId());
        int tickOffset = packet.getTickOffset();
        if (instrument == null) {
            RibbitsCommon.LOGGER.error("Tried to play music for a ribbit with null instrument!");
            return;
        }
        if (instrument == RibbitInstrumentModule.NONE) {
            RibbitsCommon.LOGGER.error("Tried to play music for a ribbit with NONE instrument!");
            return;
        }
        ClientPacketHandlerForge.queueOrExecute(entityId, entity -> {
            if (!(entity instanceof RibbitEntity)) {
                RibbitsCommon.LOGGER.error("Tried to play music for a non-ribbit entity!");
                return;
            }
            RibbitEntity ribbit = (RibbitEntity)((Object)entity);
            SoundEvent instrumentSoundEvent = instrument.getSoundEvent();
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new RibbitInstrumentSoundInstance(ribbit, tickOffset, instrumentSoundEvent));
        });
    }

    public static void handleStartAllRibbitInstruments(RibbitMusicStartAllS2CPacket packet, Supplier<NetworkEvent.Context> ctx) {
        List<UUID> entityIds = packet.getRibbitIds();
        List<ResourceLocation> instrumentIds = packet.getInstrumentIds();
        int tickOffset = packet.getTickOffset();
        if (entityIds.size() != instrumentIds.size()) {
            RibbitsCommon.LOGGER.error("Received handleStartAllPacket with {} ribbits and {} instruments!", (Object)entityIds.size(), (Object)instrumentIds.size());
            return;
        }
        for (int i = 0; i < entityIds.size(); ++i) {
            RibbitInstrument instrument = RibbitInstrumentModule.getInstrument(instrumentIds.get(i));
            if (instrument == null) {
                RibbitsCommon.LOGGER.error("Tried to play music in handleStartAllPacket for a ribbit with null instrument!");
                return;
            }
            if (instrument == RibbitInstrumentModule.NONE) {
                RibbitsCommon.LOGGER.error("Tried to play music in handleStartAllPacket for a ribbit with NONE instrument!");
                return;
            }
            ClientPacketHandlerForge.queueOrExecute(entityIds.get(i), entity -> {
                if (!(entity instanceof RibbitEntity)) {
                    RibbitsCommon.LOGGER.error("Tried to play music in handleStartAllPacket for a non-ribbit entity!");
                    return;
                }
                RibbitEntity ribbit = (RibbitEntity)((Object)entity);
                SoundEvent instrumentSoundEvent = instrument.getSoundEvent();
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new RibbitInstrumentSoundInstance(ribbit, tickOffset, instrumentSoundEvent));
            });
        }
    }

    public static void handleStopSingleRibbitInstrument(RibbitMusicStopSingleS2CPacket packet, Supplier<NetworkEvent.Context> ctx) {
        UUID entityId = packet.getRibbitId();
        ClientPacketHandlerForge.queueOrExecute(entityId, entity -> ((ISoundManagerDuck)Minecraft.m_91087_().m_91106_()).ribbits$stopRibbitsMusic(entityId));
    }

    public static void handleStartPlayerInstrument(PlayerMusicStartS2CPacket packet, Supplier<NetworkEvent.Context> ctx) {
        UUID performerId = packet.getPerformerId();
        ClientPacketHandlerForge.queueOrExecute(performerId, performer -> {
            if (!(performer instanceof Player)) {
                RibbitsCommon.LOGGER.error("Received Start Maraca packet for non-Player performer with UUID {}!", (Object)performerId);
                return;
            }
            Player playerPerformer = (Player)performer;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new PlayerInstrumentSoundInstance(playerPerformer, -1, (SoundEvent)SoundModule.MUSIC_MARACA.get()));
        });
    }

    public static void handleStopPlayerInstrument(PlayerMusicStopS2CPacket packet, Supplier<NetworkEvent.Context> ctx) {
        UUID performerId = packet.getPerformerId();
        ClientPacketHandlerForge.queueOrExecute(performerId, performer -> ((ISoundManagerDuck)Minecraft.m_91087_().m_91106_()).ribbits$stopMaraca(performerId));
    }

    public static void handleToggleSupporterHat(ToggleSupporterHatS2CPacket packet, Supplier<NetworkEvent.Context> ctx) {
        SupportersListClient.toggleSupporterHat(packet.getPlayerUuid(), packet.getEnabled());
    }

    public static void handleSupporterHatStateRequest(RequestSupporterHatStateS2CPacket packet, Supplier<NetworkEvent.Context> ctx) {
        SupportersListClient.clear();
        packet.getEnabledSupporterHatPlayers().forEach(playerUUID -> SupportersListClient.toggleSupporterHat(playerUUID, true));
        Services.SUPPORTER_HELPER.notifyServerOfSupporterHatState(RibbitOptionsJSON.get().isSupporterHatEnabled());
    }
}

